"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toString_1 = __importDefault(require("./toString"));
var words_1 = __importDefault(require("./words"));
/**
 * 将指定的 str 转换成以空格分隔的小写类型字符串，例如 `hello world`.
 * @since 1.0.0
 * @param [str = ''] (string) 带转换的字符串
 * @returns (string): 空格分割的小写类型字符串，例如 `hello world`
 * @example
 *
 * _.lowerCase('--Foo-Bar--');
 * // => 'foo bar'
 *
 * _.lowerCase('fooBar');
 * // => 'foo bar'
 *
 * _.lowerCase('__FOO_BAR__');
 * // => 'foo bar'
 */
function lowerCase(str) {
    if (str === void 0) { str = ''; }
    if ((0, isNil_1.default)(str)) {
        return str;
    }
    var strValue = str;
    if (typeof str !== 'string') {
        strValue = (0, toString_1.default)(str);
    }
    return (0, words_1.default)(strValue.replace(/['\u2019]/g, '')).reduce(function (pv, cv, idx) {
        return pv + (idx ? ' ' : '') + cv.toLowerCase();
    }, '');
}
exports.default = lowerCase;
