"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 忽略指定对象的某些属性得到一个新对象
 * @param obj，原对象
 * @param predict，判断函数，接收value和key，分别是obj的值和value，该函数应该返回一个bool
 * @return 一个基于原对象obj生成的新对象，它忽略了obj中所有predict执行为真的属性
 */
function omitBy(obj, predict) {
    var result = {};
    for (var key in obj) {
        if (!predict(obj[key], key)) {
            result[key] = obj[key];
        }
    }
    var symbolKeys = Object.getOwnPropertySymbols(obj);
    var proto = Object.getPrototypeOf(obj);
    var isEnumerable = function (s) { return proto.propertyIsEnumerable.call(proto, s); };
    while (proto) {
        symbolKeys = symbolKeys.concat(Object.getOwnPropertySymbols(proto).filter(isEnumerable));
        proto = Object.getPrototypeOf(proto);
    }
    symbolKeys.forEach(function (key) {
        if (!predict(obj[key], key)) {
            result[key] = obj[key];
        }
    });
    return result;
}
exports.default = omitBy;
