"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var debounce_1 = __importDefault(require("./debounce"));
/**
 * 节流 API，使用如下：
 * 1、生成节流函数 throttled：throttle(log, 250, { leading: false });
 * 2、事件绑定到节流函数上：addEventListener('resize', throttled);
 * 上面 throttled 在事件每次触发时都会执行，log 是待执行的实际方法 func，在等待时间内只执行一次，达到节流作用
 *
 * @param func 待执行的实际方法
 * @param wait 等待时间
 * @param options 设置项，参考 InvokeOptions 接口定义
 */
var throttle = function (func, wait, options) {
    if (options === void 0) { options = {}; }
    if (typeof func !== 'function') {
        throw new TypeError('Expected a function');
    }
    var _a = options.leading, leading = _a === void 0 ? true : _a, _b = options.trailing, trailing = _b === void 0 ? true : _b;
    return (0, debounce_1.default)(func, wait, { leading: leading, trailing: trailing, maxWait: wait });
};
exports.default = throttle;
