export * from 'log4js';
export { LocalFileWriter } from './src/common/util/local-file-writer.js';
export { noop } from './src/common/util/noop.js';
export { parseJsonFile, parseJsonText } from './src/common/util/parse-json/parse-json-util.js';
export { replacer } from './src/common/util/replacer.js';
export { isWindows, isMac, isLinux, maxPathLength } from './src/common/util/system-util.js';
export { hash, hashFile } from './src/common/util/hash-util.js';
export { PathUtil } from './src/common/util/path-util.js';
export { getModuleIndex } from './src/common/util/math-util.js';
export { HvigorCommonConst, HvigorBuildConst } from './src/base/common/options/common-const.js';
export { ReportServiceImpl } from './src/base/common/report/report-service-impl.js';
export { WatchEvent } from './src/base/common/daemon-protocol/build-event.js';
export { traceBuildAnalyze, hvigorTrace } from './src/base/common/trace/trace-build-analyze.js';
export { pluginTrace } from './src/base/common/trace/trace-util.js';
export { Tasks } from './src/base/internal/task/build/tasks.js';
export { DefaultSyncTask } from './src/base/internal/task/core/default-sync-task.js';
export { TaskDetails } from './src/base/internal/task/interface/task-details-interface.js';
export type { TaskInputValue } from './src/base/internal/snapshot/util/task-input-value-entry.js';
export { TaskState } from './src/base/internal/pool/enum/task-state.js';
export { WorkerPoolDelegator } from './src/base/internal/pool/worker-pool/worker-delegator.js';
export type { SubmitOption } from './src/base/internal/pool/worker-pool/submit-option.js';
export { PoolConstant } from './src/base/internal/pool/constant/constant.js';
export { FileSet } from './src/base/internal/snapshot/util/file-set.js';
export { projectTaskDag, TaskDirectedAcyclicGraph } from './src/base/internal/task/core/task-directed-acyclic-graph.js';
export { watchWorker, normalWorker } from './src/base/internal/pool/worker-pool/watch-worker.js';
export { startEnvironment, startParameters } from './src/base/internal/data/global-data.js';
export { ProjectCacheService } from './src/base/internal/cache/project-cache-service.js';
export { CacheStore, CacheStoreManager } from './src/base/internal/pool/store/cache-store.js';
export { TcbStore } from './src/base/internal/pool/store/tcb-store.js';
export { GlobalParam } from './src/base/external/global-param.js';
export { DefaultTask } from './src/base/external/task/default-task.js';
export { CoreTask } from './src/base/external/task/core-task.js';
export { HvigorSystemPlugin } from './src/base/external/plugin/hvigor-system-plugin.js';
export { HvigorCoreNode, Project, Module } from './src/base/external/core/hvigor-core-node.js';
export { IncrementalExecTask } from './src/base/external/task/incremental-exec-task.js';
export { defaultModelRegistry } from './src/base/external/default-tooling-model-bean-registry.js';
export { hvigor, getHvigorNode, getHvigorConfigValue, getNode } from './src/base/external/core/hvigor.js';
export type { ToolingModelBean } from './src/base/external/tooling-model-bean.js';
export { addExtensionHandler } from './src/base/boot/hooks/require-hook.js';
export { globalData } from './src/base/internal/data/global-data.js';
export { HvigorLogger } from './src/base/log/hvigor-log.js';
export { getConfiguration, levelMap, setCategoriesLevel } from './src/base/log/default-configuration.js';
export { Json5Reader } from './src/base/util/json5-reader.js';
export { iconv } from './src/common/util/iconv';
export { splitTime, formatTime } from './src/base/util/time-util.js';
export { DurationEvent } from './src/base/metrics/event/duration-event.js';
export { ContinualEvent } from './src/base/metrics/event/continual-event.js';
export { MarkEvent, MarkEventType } from './src/base/metrics/event/mark-event.js';
export { MAIN_THREAD, MetricFactory } from './src/base/metrics/metric-factory.js';
export { MetricService } from './src/base/metrics/metric-service.js';
export { MetricLogType } from './src/base/metrics/event/log-event.js';
export { MetricEventType } from './src/base/metrics/event/base-event.js';
export { HvigorTaskGroupType } from './src/base/external/task/core-task.js';
/** Hvigor基础接口 **/
export { HvigorPlugin, HvigorNode, HvigorTask, HvigorTaskContext, Task, TaskInput, TaskOutput, } from './src/base/external/api/hvigor-api.js';
/** 弃用接口 **/
export { HvigorPluginContext } from './src/base/external/api/hvigor-api.js';
