export declare function createAssignFunction(assigner: Function): (object: any, ...sources: any[]) => any;
/**
 * 分配来源对象的可枚举属性到目标对象上。 来源对象的应用规则是从左到右，随后的下一个对象的属性会覆盖上一个对象的属性。
 *
 * **注意**： 这方法会改变 object，参考自 [Object.assign](https://mdn.io/Object/assign)
 *
 * @public
 * @since 1.0.0
 * @param object (Object): 目标对象
 * @param sources (...Object): 来源对象。
 * @returns (Object): 返回 object.
 * @example
 * ```
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * function Bar() {
 *   this.c = 3;
 * }
 *
 * Foo.prototype.b = 2;
 * Bar.prototype.d = 4;
 *
 * _.assign({ 'a': 0 }, new Foo, new Bar);
 * // => { 'a': 1, 'c': 3 }
 * ```
 */
declare function assign(object: Object, ...sources: any): any;
export default assign;
