"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.baseIsMatch = void 0;
var Stack_1 = require("./Stack");
var baseIsEqual_1 = require("./baseIsEqual");
var COMPARE_PARTIAL_FLAG = 1;
var COMPARE_UNORDERED_FLAG = 2;
function baseIsMatch(objParam, source, matchData, customizer) {
    var object = objParam;
    var index = matchData.length;
    var length = index;
    var noCustomizer = !customizer;
    if (object == null) {
        return !length;
    }
    object = Object(object);
    var data;
    while (index--) {
        data = matchData[index];
        if ((noCustomizer && data[2])
            ? data[1] !== object[data[0]]
            : !(data[0] in object)) {
            return false;
        }
    }
    while (++index < length) {
        data = matchData[index];
        var key = data[0];
        var objValue = object[key];
        var srcValue = data[1];
        if (matchCustomizer(noCustomizer, data, objValue, key, object, customizer, srcValue, source) === false) {
            return false;
        }
    }
    return true;
}
exports.baseIsMatch = baseIsMatch;
function matchCustomizer(noCustomizer, data, objValue, key, obj, customizer, srcValue, source) {
    if (noCustomizer && data[2]) {
        if (objValue === undefined && !(key in obj)) {
            return false;
        }
    }
    else {
        var stack = new Stack_1.Stack(undefined);
        var result = void 0;
        if (customizer) {
            result = customizer(objValue, srcValue, key, obj, source, stack);
        }
        if (!(result === undefined
            ? (0, baseIsEqual_1.baseIsEqual)(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
            : result)) {
            return false;
        }
    }
}
