"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2023. All rights reserved.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var reduce_1 = __importDefault(require("../reduce"));
var isArrayLike_1 = __importDefault(require("../isArrayLike"));
var forEach_1 = __importDefault(require("../forEach"));
var sameValueZero_1 = __importDefault(require("./sameValueZero"));
var last_1 = __importDefault(require("../last"));
var isFunction_1 = __importDefault(require("../isFunction"));
function baseUnion() {
    var arrays = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        arrays[_i] = arguments[_i];
    }
    var newArgs = [[]].concat(arrays);
    var allItems = newArgs;
    var comparator = (0, last_1.default)(newArgs);
    if ((0, isFunction_1.default)(comparator)) {
        allItems.pop();
    }
    else {
        comparator = sameValueZero_1.default;
    }
    return (0, reduce_1.default)(allItems, function (result, oneArray) {
        // 不是 array不行；但是允许 arguments 这类对象
        if (!(0, isArrayLike_1.default)(oneArray)) {
            return result;
        }
        (0, forEach_1.default)(oneArray, function (one) {
            var oneIdx = result.findIndex(function (item) { return comparator(one, item); });
            if (oneIdx === -1) {
                result.push(one);
            }
        });
        return result;
    });
}
exports.default = baseUnion;
