"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 该函数接受多个函数作为入参（funcArr），而后返回一个新函数fn
 * fn在执行时，依次调用之前的多个函数，前一个函数的输出将作为后一个函数的输入
 * 最后一个函数的输出作为fn函数的返回结果
 * @param funcArr，多个函数入参组成的数组
 * @return 返回一个新函数fn，其被调用时会依次执行funcArr中函数，并返回最终得到的结果
 */
function flow() {
    var funcArr = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        funcArr[_i] = arguments[_i];
    }
    // fn是flow函数要返回的新函数
    var fn = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var nextInputs = __spreadArray([], __read(args), false);
        funcArr.forEach(function (func) {
            nextInputs = [func.apply(void 0, __spreadArray([], __read(nextInputs), false))];
        });
        return nextInputs[0];
    };
    return fn;
}
exports.default = flow;
