"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArray_1 = __importDefault(require("./isArray"));
var isSymbol_1 = __importDefault(require("./isSymbol"));
var validCheck_1 = require("./common/validCheck");
// null、undefined、Symbol 没有toString方法
function toString(value) {
    if ((0, isSymbol_1.default)(value)) {
        return value;
    }
    return "".concat(value);
}
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar = /\\(\\)?/g;
/**
 * 将字符串转成路径数组。支持a.b.c及a.b[c]形式
 *
 * @private
 * @param {string} path 要转换的路径
 */
function parseStringToPathArr(path) {
    var result = [];
    if (path[0] === '.') {
        result.push('');
    }
    path.replace(rePropName, function (match, number, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
        return match;
    });
    return result;
}
function castPath(value, object) {
    if ((0, isArray_1.default)(value)) {
        return value;
    }
    if ((0, isSymbol_1.default)(value) || value in object) {
        return [value];
    }
    return parseStringToPathArr(toString(value));
}
function isIndexOfArray(object, key) {
    if (!(0, isArray_1.default)(object) && !(0, validCheck_1.isArguments)(object)) {
        return false;
    }
    var index = Number(key);
    return index > -1 && index <= Number.MAX_SAFE_INTEGER && index < object.length;
}
/**
 * 检查 path 是否是object对象的直接属性，根据多段路径查询嵌套对象
 *
 * @private
 * @param {Object} object 要查询的对象
 * @param {Array|string} path 要查询的路径。多段路径由英文句号.隔开
 * @param {Function} hasFunc 是否属于当前遍历层级的对象的判断方法
 * @returns {boolean} 该路径能在该对象查找到，则为true，否则为false
 */
function hasPath(object, path, hasFunc) {
    var paths = castPath(path, object);
    var length = paths.length;
    var index = -1;
    var currentObj = object;
    while (++index < length) {
        var key = toString(paths[index]);
        if (!hasFunc(currentObj, key) && !isIndexOfArray(currentObj, key)) {
            return false;
        }
        currentObj = currentObj[key];
    }
    return true;
}
exports.default = hasPath;
