"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var get_1 = __importDefault(require("./get"));
var stringToPaths_1 = require("./common/stringToPaths");
/**
 * 调用obj中path所指向的函数并返回结果
 * @param obj，要调用的函数所属的对象
 * @param rawPath，obj的属性路径，用于指定要调用的函数
 * @param args，调用函数时传入的参数
 * @return 返回调用函数得到的结果
 */
function invoke(obj, rawPath) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    var path = (0, stringToPaths_1.getObjValidPathFromGeneralPath)(obj, rawPath);
    var length = path.length;
    var lastAttribute = path[length - 1];
    // 获得path路径倒数第二层属性所指向的值，其需要作为函数调用时的this
    var actualInvokeObj = length > 1 ? (0, get_1.default)(obj, path.slice(0, length - 1)) : obj;
    return actualInvokeObj === undefined || actualInvokeObj === null
        ? undefined
        : actualInvokeObj[lastAttribute].apply(actualInvokeObj, __spreadArray([], __read(args), false));
}
exports.default = invoke;
