"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
/**
 * 检查 value 对象是否是 Symbol
 * @Catalog lang
 * @param value
 */
function isSymbol(value) {
    if (value === void 0) { value = undefined; }
    var vType = typeof value;
    return vType === 'symbol' || (vType === 'object' && value != null && (0, utils_1.tagName)(value) === '[object Symbol]');
}
exports.default = isSymbol;
