"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 检查字符串string是否以 target 开头
 * @param str: 要检索的字符串
 * @param target: 要检查的字符串
 * @param position: 检索的位置
 */
function startsWith(str, target, position) {
    var pos = (position === undefined || position === null) ? 0 : position;
    if (pos < 0 || Number.isNaN(pos)) {
        pos = 0;
    }
    if (pos > str.length) {
        pos = str.length;
    }
    return pos >= 0 && str.slice(pos, pos + target.length) === target;
}
exports.default = startsWith;
