/**
 * 将指定的 `value` 转换为整数，转换结果 NaN 时，返回 0；
 * 如果传入值是个小数，它将截断小数部分。
 *
 * **注意:** 这个方法并不是完全的 ECMA 的这个标准一致。
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger)。
 *
 * @since 1.0.0
 * @category Lang
 * @param {*} value 待转换的数据
 * @returns {number} 转换之后的整数
 * @example
 * ```
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 * ```
 */
export default function toInteger(value: any): number;
