"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 从string字符串中移除前面和后面的 空格 或 指定的字符
 * @param value: 要处理的字符串
 * @param chars: 指定字符
 */
function trim(value, chars) {
    if (value === null || value === undefined) {
        return '';
    }
    if (value && !chars) {
        return value.trim();
    }
    var charSet = new Set(chars && chars.split(''));
    charSet.add(' ');
    var array = value.split('');
    var startIndex = 0;
    var endIndex = array.length - 1;
    for (var i = 0; i < array.length; i++) {
        if (!charSet.has(array[i])) {
            startIndex = i;
            break;
        }
    }
    for (var i = array.length - 1; i > startIndex; i--) {
        if (!charSet.has(array[i])) {
            endIndex = i;
            break;
        }
    }
    return array.slice(startIndex, endIndex + 1).join('');
}
exports.default = trim;
