"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var fromPairs_1 = __importDefault(require("./fromPairs"));
var take_1 = __importDefault(require("./take"));
var zip_1 = __importDefault(require("./zip"));
/**
 * 将 keys 和 values 按索引顺序拼接为 key-value 键值对
 *
 * @export
 * @param {Key[]} [keys=[]] 键数组
 * @param {any[]} [values=[]] 值数组
 * @returns 拼接的key-value 键值对
 * @example
 *
 * zipObject(['a', 'b'], [1, 2])
 * // => { 'a': 1, 'b': 2 }
 */
function zipObject(keys, values) {
    if (keys === void 0) { keys = []; }
    if (values === void 0) { values = []; }
    return (0, fromPairs_1.default)((0, zip_1.default)(keys, (0, take_1.default)(values, keys.length)));
}
exports.default = zipObject;
