/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
 */

// 导入依赖
const terser = require('@rollup/plugin-terser');
const commonjs = require('@rollup/plugin-commonjs');
const { nodeResolve } =require('@rollup/plugin-node-resolve');

// tsconfig.json合并选项

module.exports = {
  // 项目入口
  input: './src/wrapper/hvigor-wrapper.ts',

  // 打包后的出口和设置
  output: {
    file: './src/wrapper/script/hvigor/hvigor-wrapper.js',
    format: 'cjs',
    sourcemap: false,
    compact: true
  },

  plugins: [nodeResolve(), commonjs({
    ignoreDynamicRequires: true
  }), terser()],
};
