"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.defaultSessionManager=exports.SESSION_EMIT_LOG=void 0;const cluster_1=__importDefault(require("cluster")),events_1=__importDefault(require("events")),build_event_js_1=require("../../common/daemon-protocol/build-event.js"),message_js_1=require("../../common/daemon-protocol/message.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),session_map_js_1=require("./session-map.js"),_log=hvigor_log_js_1.HvigorLogger.getLogger("daemon");exports.SESSION_EMIT_LOG="emitLog";class SessionManager extends events_1.default{constructor(){super(),this.sessionMap=new session_map_js_1.SessionMap,this.serverSockets=[],this.addListenersOnSocket()}initSession(e){this.serverSockets.push(e),this.sessionMap.setSession(e.id,void 0)}endSession(e){const s=this.serverSockets.indexOf(e);-1!==s&&(this.serverSockets.splice(s,1),this.sessionMap.deleteBySocketId(e.id))}bindThread(e,s){this.sessionMap.checkBySocketId(e)&&this.sessionMap.setSession(e,s)}bindProcess(e,s){this.sessionMap.checkBySocketId(e)&&this.sessionMap.setSession(e,(0,session_map_js_1.getThreadId)(s,0))}getSockets(){return this.serverSockets}getLength(){return this.serverSockets.length}getSocketByThreadId(e){const s=this.sessionMap.getSocketId(e);return this.serverSockets.find((e=>e.id===s))}getSocketBySocketId(e){return this.serverSockets.find((s=>s.id===e))}hasSocket(e){return this.serverSockets.some((s=>s.id===e))}getThreadId(e){return this.sessionMap.getThreadId(e)}postMessageToThread(e,s){const t=this.getThreadId(e);if(!t)return void _log.warn(`session manager: cannot find corresponding thread for socket id ${e}.`);const[o,r]=(0,session_map_js_1.resolveThreadId)(t);if(cluster_1.default.isMaster){const e=cluster_1.default.workers[o];if(void 0===e)return void _log.warn(`session manager: cannot find corresponding worker process for process id ${o}.`);_log.debug("session manager: send message to worker process."),e.send({...s,workerId:r})}else _log.warn("session manager: not master process, should be an error.")}setActiveSocket(e){_log.debug(`session manager: set active socket. socketId=${e.id}`),this.curActiveSocket=e}resetActiveSocket(){this.curActiveSocket=void 0}getActiveSocket(){return this.curActiveSocket}addListenersOnSocket(){cluster_1.default.isMaster&&cluster_1.default.on("message",((e,s)=>{if(!s.type)return;let t;switch(s.type){case build_event_js_1.WatchEvent.NEW_WATCH_WORKER:if(this.curActiveSocket){const t=this.curActiveSocket.id,o=(0,session_map_js_1.getThreadId)(e.id,s.workerId);this.bindThread(t,o),_log.debug(`session manager: binding session. socketId=${t}, threadId=${o}.`),this.curActiveSocket.on(build_event_js_1.WatchEvent.WATCH_COMPILE_DATA,(async e=>{_log.debug("session manager: receive watch compile data."),exports.defaultSessionManager.postMessageToThread(t,{type:build_event_js_1.WatchEvent.WATCH_COMPILE_DATA,content:e})})),this.curActiveSocket.on(build_event_js_1.WatchEvent.CLOSE_WATCH,(async()=>{_log.debug("session manager: receive close watch request."),exports.defaultSessionManager.postMessageToThread(t,{type:build_event_js_1.WatchEvent.CLOSE_WATCH})}))}break;case build_event_js_1.WatchEvent.WATCH_COMPILE_RESULT:case build_event_js_1.WatchEvent.WATCH_START:case build_event_js_1.WatchEvent.WATCH_RESULT:case build_event_js_1.WatchEvent.WATCH_LOG:t=this.getSocketByThreadId((0,session_map_js_1.getThreadId)(e.id,s.workerId)),_log.debug(`session manager: watch message received from worker ${e.id}. Type: ${s.type}`),void 0===t?_log.debug(`session manager: undefined socket. Type: ${s.type}`):t.emit(s.type,s.content);case build_event_js_1.WatchEvent.TERMINATE_WORKER:}}))}}exports.defaultSessionManager=new SessionManager,exports.defaultSessionManager.on(exports.SESSION_EMIT_LOG,((e,s,t)=>{const o=exports.defaultSessionManager.getActiveSocket();void 0!==o&&o.emit(build_event_js_1.BuildEvent.OUTPUT,(0,message_js_1.createOutput)(e,s,t))}));