"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.logDaemonInfo=exports.stopDaemons=exports.isHvigorDaemonProcess=void 0;const child_process_1=require("child_process"),fs_extra_1=__importDefault(require("fs-extra")),os_1=__importDefault(require("os")),path_1=__importDefault(require("path")),process_1=__importDefault(require("process")),system_util_js_1=require("../../../common/util/system-util.js"),exit_js_1=require("../../boot/hooks/exit.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),daemon_const_js_1=require("../const/daemon-const.js"),daemon_info_js_1=require("../registry/daemon-info.js"),_log=hvigor_log_js_1.HvigorLogger.getLogger("process-info-util");function isHvigorDaemonProcess(e){if(e<=0)return!1;try{process_1.default.kill(e,0)}catch(e){return!1}if((0,system_util_js_1.isWindows)()){if(examineHvigorDaemonProcess(`${path_1.default.resolve("C:\\Windows","System32","wbem","wmic")} process where processid="${e}" get processid,caption,commandline`,e))return!0;return!!examineHvigorDaemonProcess(`powershell "Get-CimInstance -ClassName Win32_Process -Filter 'ProcessId LIKE ${e}' -Property ProcessId,Caption,commandline"${os_1.default.EOL}`,e)||(_log.warn(`hvigor client: Check process info failed. If process with pid=${e} exists and it is an hvigor process, please check the WMI function of your environment or starting hvigor with --no-daemon param.`),!1)}if((0,system_util_js_1.isLinux)()||(0,system_util_js_1.isMac)()){return examineHvigorDaemonProcess(`ps -fp ${e}`,e)}return!1}function examineHvigorDaemonProcess(e,o){try{const s=(0,child_process_1.execSync)(e,{windowsHide:!0,encoding:"utf-8"}).toString();return s.includes(o.toString())&&s.includes("node")&&s.includes("hvigor")&&s.includes("daemon-process-boot-script")}catch(e){return _log.warn(e),!1}}function stopDaemons(e){const o=fs_extra_1.default.readJsonSync(daemon_const_js_1.DEFAULT_DAEMON_REGISTRY_PATH,{encoding:"utf-8"});let s=0;Object.values(o).forEach((t=>{t.state!==daemon_info_js_1.DaemonState.STOPPED&&t.state!==daemon_info_js_1.DaemonState.BROKEN&&(e||path_1.default.normalize(t.cwdPath)===path_1.default.normalize(process_1.default.cwd()))&&(t.state=daemon_info_js_1.DaemonState.STOPPED,killDaemonProcess(t)?s++:delete o[t.keyId])})),_log.info(`Stopped ${s} daemon${s>1?"s":""} in total.`),fs_extra_1.default.writeJsonSync(daemon_const_js_1.DEFAULT_DAEMON_REGISTRY_PATH,o),(0,exit_js_1.exit)(0)}function killDaemonProcess(e){return isHvigorDaemonProcess(e.pid)?(process_1.default.kill(e.pid,"SIGTERM"),_log.info(`Stopped daemon pid ${e.pid}.`),!0):(_log.warn(`process pid ${e.pid} is not a hvigor daemon. The process will not be killed and the info will be clear. `),!1)}function logDaemonInfo(){_log.info("PID\tSTATUS\tPORT\tROOT_PATH");try{const e=fs_extra_1.default.readJsonSync(daemon_const_js_1.DEFAULT_DAEMON_REGISTRY_PATH,{encoding:"utf-8"});Object.values(e).forEach((e=>{_log.info(`${e.pid}\t${e.state}\t${e.port}\t${e.cwdPath}`)}))}finally{(0,exit_js_1.exit)(0)}}exports.isHvigorDaemonProcess=isHvigorDaemonProcess,exports.stopDaemons=stopDaemons,exports.logDaemonInfo=logDaemonInfo;