import { Log } from '../utils/Log';
const log = new Log('AVPBase');
const preparedListenerMap = new WeakMap();
const onInfoListenerMap = new WeakMap();
const onRenderingStartListenerMap = new WeakMap();
const onStateChangedListenerMap = new WeakMap();
const onCompletionListenerMap = new WeakMap();
const onLoadingStatusListenerMap = new WeakMap();
const onErrorListenerMap = new WeakMap();
const onVideoSizeChangedListenerMap = new WeakMap();
const onSeekCompleteListenerMap = new WeakMap();
const onSubtitleDisplayListenerMap = new WeakMap();
const onVideoRenderedListenerMap = new WeakMap();
const onAudioInterruptEventListenerMap = new WeakMap();
const onTrackReadyListenerMap = new WeakMap();
const onSubTrackReadyListenerMap = new WeakMap();
const onSwichStreamListenerMap = new WeakMap();
const onAVNotSyncStatusListenerMap = new WeakMap();
const onTrackChangedListenerMap = new WeakMap();
const onSnapShotListenerMap = new WeakMap();
const onSeiDataListenerMap = new WeakMap();
const onNetworkStatusMap = new WeakMap();
export class AVPBase {
    constructor(o18, p18) {
        this.mOutMediaInfo = null;
        this.mOutSubMediaInfo = null;
        this.mOutOnPreparedListener = null;
        this.mInnerOnPreparedListener = new InnerPrepareListener(this);
        this.mOutOnInfoListener = null;
        this.mInnerOnInfoListener = new InnerInfoListener(this);
        this.mOutOnRenderingStartListener = null;
        this.mInnerOnRenderingStartListener = new InnerRenderingStartListener(this);
        this.mOutOnStateChangedListener = null;
        this.mInnerOnStateChangedListener = new InnerStateChangedListener(this);
        this.mOutOnVideoSizeChangedListener = null;
        this.mInnerOnVideoSizeChangedListener = new InnerVideoSizeChangedListener(this);
        this.mOutOnLoadingStatusListener = null;
        this.mInnerOnLoadingStatusListener = new InnerLoadingStatusListener(this);
        this.mOutOnSeekCompleteListener = null;
        this.mInnerOnSeekCompleteListener = new InnerSeekCompleteListener(this);
        this.mOutOnCompletionListener = null;
        this.mInnerOnCompletionListener = new InnerCompletionListener(this);
        this.mOutOnVideoRenderedListener = null;
        this.mInnerOnVideoRenderedListener = new InnerVideoRenderedListener(this);
        this.mOutOnSubtitleDisplayListener = null;
        this.mInnerOnSubtitleDisplayListener = new InnerSubtitleDisplayListener(this);
        this.mOutOnErrorListener = null;
        this.mInnerOnErrorListener = new InnerErrorListener(this);
        this.mOutOnAudioInterruptEventListener = null;
        this.mInnerOnAudioInterruptEventListener = new InnerAudioInterruptEventListener(this);
        this.mOutOnTrackReadyListener = null;
        this.mInnerOnTrackReadyListener = new InnerTrackReadyListener(this);
        this.mOutOnSubTrackReadyListener = null;
        this.mInnerOnSubTrackReadyListener = new InnerSubTrackReadyListener(this);
        this.mOutOnStreamSwitchedListener = null;
        this.mInnerOnStreamSwitchedListener = new InnerStreamSwitchedListener(this);
        this.mOutOnAVNotSyncStatusListener = null;
        this.mInnerOnAVNotSyncStatusListener = new InnerOnAVNotSyncStatusListener(this);
        this.mOutOnNetworkStatsListener = null;
        this.mInnerOnNetworkStatsListener = new InnerOnNetworkStatsListener(this);
        this.mOutOnTrackChangedListener = null;
        this.mInnerOnTrackChangedListener = new InnerTrackChangedListener(this);
        this.mOutOnSnapShotListener = null;
        this.mInnerOnSnapShotListener = new InnerSnapShotListener(this);
        this.mOutOnSeiDataListener = null;
        this.mInnerOnSeiDataListener = new InnerSeiDataListener(this);
        this.mContext = o18;
        this.mTraceId = p18;
        this.mCorePlayer = this.createAlivcMediaPlayer(o18);
        this.mCorePlayer.setTraceId(this.mTraceId);
        preparedListenerMap.set(this, this.mInnerOnPreparedListener);
        onInfoListenerMap.set(this, this.mInnerOnInfoListener);
        onRenderingStartListenerMap.set(this, this.mInnerOnRenderingStartListener);
        onStateChangedListenerMap.set(this, this.mInnerOnStateChangedListener);
        onCompletionListenerMap.set(this, this.mInnerOnCompletionListener);
        onLoadingStatusListenerMap.set(this, this.mInnerOnLoadingStatusListener);
        onErrorListenerMap.set(this, this.mInnerOnErrorListener);
        onVideoSizeChangedListenerMap.set(this, this.mInnerOnVideoSizeChangedListener);
        onSeekCompleteListenerMap.set(this, this.mInnerOnSeekCompleteListener);
        onSubtitleDisplayListenerMap.set(this, this.mInnerOnSubtitleDisplayListener);
        onVideoRenderedListenerMap.set(this, this.mInnerOnVideoRenderedListener);
        onAudioInterruptEventListenerMap.set(this, this.mInnerOnAudioInterruptEventListener);
        onTrackReadyListenerMap.set(this, this.mInnerOnTrackReadyListener);
        onSubTrackReadyListenerMap.set(this, this.mInnerOnSubTrackReadyListener);
        onSwichStreamListenerMap.set(this, this.mInnerOnStreamSwitchedListener);
        onAVNotSyncStatusListenerMap.set(this, this.mInnerOnAVNotSyncStatusListener);
        onNetworkStatusMap.set(this, this.mInnerOnNetworkStatsListener);
        onTrackChangedListenerMap.set(this, this.mInnerOnTrackChangedListener);
        onSnapShotListenerMap.set(this, this.mInnerOnSnapShotListener);
        onSeiDataListenerMap.set(this, this.mInnerOnSeiDataListener);
        this.bindListener();
    }
    getNativeContextAddr() {
        return this.mCorePlayer?.getNativeContextAddr();
    }
    prepare() {
        this.prepareInner();
    }
    prepareInner() {
        this.mCorePlayer?.prepare();
    }
    getCorePlayer() {
        return this.mCorePlayer;
    }
    start() {
        this.startInner();
    }
    startInner() {
        this.mCorePlayer?.start();
    }
    pause() {
        this.pauseInner();
    }
    pauseInner() {
        this.mCorePlayer?.pause();
    }
    stop() {
        let n18 = "protected.playEvent.user.stop";
        this.setGlobalTime(n18);
        this.stopInner();
    }
    stopInner() {
        this.mCorePlayer?.stop();
    }
    setAutoPlay(m18) {
        this.mCorePlayer?.setAutoPlay(m18);
    }
    setSurfaceId(l18) {
        this.mCorePlayer?.setSurfaceId(l18);
    }
    setSpeed(k18) {
        this.mCorePlayer?.setSpeed(k18);
    }
    setVolume(j18) {
        this.mCorePlayer?.setVolume(j18);
    }
    getVolume() {
        return this.mCorePlayer?.getVolume();
    }
    seekTo(h18, i18) {
        this.mCorePlayer?.seekTo(h18, i18);
    }
    setStartTime(f18, g18) {
        this.mCorePlayer?.setStartTime(f18, g18);
    }
    getDuration() {
        return this.mCorePlayer?.getDuration();
    }
    getPlayedDuration() {
        return this.mCorePlayer?.getPlayedDuration();
    }
    getCurrentPosition() {
        return this.mCorePlayer?.getCurrentPosition();
    }
    getBufferedPosition() {
        return this.mCorePlayer?.getBufferedPosition();
    }
    getPlayerStatus() {
        return this.mCorePlayer?.getPlayerStatus();
    }
    enableHardwareDecoder(e18) {
        this.mCorePlayer?.enableHardwareDecoder(e18);
    }
    release() {
        let d18 = "protected.playEvent.user.destroy";
        this.setGlobalTime(d18);
        this.releaseInner();
    }
    setGlobalTime(c18) {
        this.mCorePlayer?.setGlobalTime(c18);
    }
    releaseInner() {
        this.mCorePlayer?.release();
    }
    releaseAsync() {
        let a18 = "protected.playEvent.user.destroy";
        this.setGlobalTime(a18);
        log.info('releaseAsync');
        this.pause();
        setTimeout(() => {
            this.stopInner();
            this.releaseInner();
        }, 0);
    }
    setMute(z17) {
        this.mCorePlayer?.setMute(z17);
    }
    isMuted() {
        return this.mCorePlayer?.isMuted();
    }
    setScaleMode(y17) {
        this.mCorePlayer?.setScaleMode(y17);
    }
    getScaleMode() {
        return this.mCorePlayer?.getScaleMode();
    }
    setLoop(x17) {
        this.mCorePlayer?.setLoop(x17);
    }
    isLoop() {
        return this.mCorePlayer?.isLoop();
    }
    getVideoWidth() {
        return this.mCorePlayer?.getVideoWidth();
    }
    getVideoHeight() {
        return this.mCorePlayer?.getVideoHeight();
    }
    getVideoRotation() {
        return this.mCorePlayer?.getVideoRotation();
    }
    reload() {
        this.mCorePlayer?.reload();
    }
    setRotateMode(w17) {
        this.mCorePlayer?.setRotateMode(w17);
    }
    getRotateMode() {
        return this.mCorePlayer?.getRotateMode();
    }
    setMirrorMode(v17) {
        this.mCorePlayer?.setMirrorMode(v17);
    }
    getMirrorMode() {
        return this.mCorePlayer?.getMirrorMode();
    }
    setAlphaRenderMode(u17) {
        this.mCorePlayer?.setAlphaRenderMode(u17);
    }
    getAlphaRenderMode() {
        return this.mCorePlayer?.getAlphaRenderMode();
    }
    setVideoBackgroundColor(t17) {
        this.mCorePlayer?.setVideoBackgroundColor(t17);
    }
    getSpeed() {
        return this.mCorePlayer?.getSpeed();
    }
    isAutoPlay() {
        return this.mCorePlayer?.isAutoPlay();
    }
    setConfig(s17) {
        this.mCorePlayer?.setConfig(s17);
    }
    getConfig() {
        return this.mCorePlayer?.getConfig();
    }
    setPlayerScene(r17) {
        this.mCorePlayer?.setPlayerScene(r17);
    }
    setOption(o17, p17) {
        let q17 = "player_option_" + o17 + "_str";
        this.mCorePlayer?.setOption(q17, p17);
    }
    setOptionNum(l17, m17) {
        let n17 = "player_option_" + l17.toString() + "_str";
        this.mCorePlayer?.setOption(n17, m17.toString());
    }
    getOption(k17) {
        return this.mCorePlayer?.getOption(k17);
    }
    selectTrack(j17) {
        this.mCorePlayer?.selectTrack(j17);
    }
    switchStream(i17) {
        this.mCorePlayer?.switchStream(i17);
    }
    getMediaInfo() {
        return this.mOutMediaInfo;
    }
    getSubMediaInfo() {
        return this.mOutSubMediaInfo;
    }
    currentTrack(h17) {
        if (this.mCorePlayer) {
            return this.mCorePlayer.getCurrentTrack(h17);
        }
        else {
            return null;
        }
    }
    addExtSubtitle(g17) {
        this.mCorePlayer?.addExtSubtitle(g17);
    }
    ;
    selectExtSubtitle(e17, f17) {
        this.mCorePlayer?.selectExtSubtitle(e17, f17);
    }
    setStreamDelay(c17, d17) {
        this.mCorePlayer?.setStreamDelay(c17, d17);
    }
    setMaxAccurateSeekDelta(b17) {
        this.mCorePlayer?.setMaxAccurateSeekDelta(b17);
    }
    setCacheConfig(a17) {
        this.mCorePlayer?.setCacheConfig(a17);
    }
    setIPResolveType(z16) {
        this.mCorePlayer?.setIPResolveType(z16);
    }
    setFastStart(y16) {
        this.mCorePlayer?.setFastStart(y16);
    }
    snapShot() {
        this.mCorePlayer?.snapShot();
    }
    clearScreen() {
        this.mCorePlayer?.clearScreen();
    }
    getCacheFilePathByUrl(x16) {
        return this.mCorePlayer?.getCacheFilePathByUrl(x16) ?? '';
    }
    getCacheFilePathByVid(t16, u16, v16, w16) {
        return this.mCorePlayer?.getCacheFilePathByVid(t16, u16, v16, w16) ?? '';
    }
    getPropertyString(s16) {
        return this.mCorePlayer?.getPropertyString(s16) ?? '';
    }
    setDefaultBandWidth(r16) {
        this.mCorePlayer?.setDefaultBandWidth(r16);
    }
    setDefaultResolution(q16) {
        this.mCorePlayer?.setDefaultResolution(q16);
    }
    sendCustomEvent(p16) {
        this.mCorePlayer?.sendCustomEvent(p16);
    }
    setVideoTag(o16) {
        this.mCorePlayer?.setVideoTag(o16);
    }
    setUserData(n16) {
        this.mCorePlayer?.setUserData(n16);
    }
    setTraceId(m16) {
        this.mCorePlayer?.setTraceId(m16);
    }
    getUserData() {
        return this.mCorePlayer?.getUserData() ?? '';
    }
    bindListener() {
        this.mCorePlayer?.setOnPreparedListener(this.mInnerOnPreparedListener);
        this.mCorePlayer?.setOnInfoListener(this.mInnerOnInfoListener);
        this.mCorePlayer?.setOnRenderingStartListener(this.mInnerOnRenderingStartListener);
        this.mCorePlayer?.setOnStateChangedListener(this.mInnerOnStateChangedListener);
        this.mCorePlayer?.setOnVideoSizeChangedListener(this.mInnerOnVideoSizeChangedListener);
        this.mCorePlayer?.setOnLoadingStatusListener(this.mInnerOnLoadingStatusListener);
        this.mCorePlayer?.setOnSeekCompleteListener(this.mInnerOnSeekCompleteListener);
        this.mCorePlayer?.setOnCompletionListener(this.mInnerOnCompletionListener);
        this.mCorePlayer?.setOnVideoRenderedListener(this.mInnerOnVideoRenderedListener);
        this.mCorePlayer?.setOnSubtitleDisplayListener(this.mInnerOnSubtitleDisplayListener);
        this.mCorePlayer?.setOnErrorListener(this.mInnerOnErrorListener);
        this.mCorePlayer?.setOnAudioInterruptEventListener(this.mInnerOnAudioInterruptEventListener);
        this.mCorePlayer?.setOnTrackReadyListener(this.mInnerOnTrackReadyListener);
        this.mCorePlayer?.setOnSubTrackReadyListener(this.mInnerOnSubTrackReadyListener);
        this.mCorePlayer?.setOnStreamSwitchedListener(this.mInnerOnStreamSwitchedListener);
        this.mCorePlayer?.setOnAVNotSyncStatusListener(this.mInnerOnAVNotSyncStatusListener);
        this.mCorePlayer?.setOnNetworkStatsListener(this.mInnerOnNetworkStatsListener);
        this.mCorePlayer?.setOnTrackChangedListener(this.mInnerOnTrackChangedListener);
        this.mCorePlayer?.setOnSnapShotListener(this.mInnerOnSnapShotListener);
        this.mCorePlayer?.setOnSeiDataListener(this.mInnerOnSeiDataListener);
    }
    setOnPreparedListener(l16) {
        this.mOutOnPreparedListener = l16;
    }
    setOnInfoListener(k16) {
        this.mOutOnInfoListener = k16;
    }
    setOnRenderingStartListener(j16) {
        this.mOutOnRenderingStartListener = j16;
    }
    setOnStateChangedListener(i16) {
        this.mOutOnStateChangedListener = i16;
    }
    setOnCompletionListener(h16) {
        this.mOutOnCompletionListener = h16;
    }
    setOnAVNotSyncStatusListener(g16) {
        this.mOutOnAVNotSyncStatusListener = g16;
    }
    setOnNetworkStatsListener(f16) {
        this.mOutOnNetworkStatsListener = f16;
    }
    setOnStreamSwitchedListener(e16) {
        this.mOutOnStreamSwitchedListener = e16;
    }
    setOnLoadingStatusListener(d16) {
        this.mOutOnLoadingStatusListener = d16;
    }
    setOnErrorListener(c16) {
        this.mOutOnErrorListener = c16;
    }
    setOnVideoSizeChangedListener(b16) {
        this.mOutOnVideoSizeChangedListener = b16;
    }
    setOnSeekCompleteListener(a16) {
        this.mOutOnSeekCompleteListener = a16;
    }
    setOnSubtitleDisplayListener(z15) {
        this.mOutOnSubtitleDisplayListener = z15;
    }
    setOnVideoRenderedListener(y15) {
        this.mOutOnVideoRenderedListener = y15;
    }
    setOnAudioInterruptEventListener(x15) {
        this.mOutOnAudioInterruptEventListener = x15;
    }
    setOnTrackReadyListener(w15) {
        this.mOutOnTrackReadyListener = w15;
    }
    setOnSubTrackReadyListener(v15) {
        this.mOutOnSubTrackReadyListener = v15;
    }
    setOnTrackChangedListener(u15) {
        this.mOutOnTrackChangedListener = u15;
    }
    setOnSnapShotListener(t15) {
        this.mOutOnSnapShotListener = t15;
    }
    setOnSeiDataListener(s15) {
        this.mOutOnSeiDataListener = s15;
    }
    onPrepared() {
        if (this.mOutOnPreparedListener != null) {
            this.mOutOnPreparedListener.onPrepared();
        }
    }
    onInfo(r15) {
        if (this.mOutOnInfoListener != null) {
            this.mOutOnInfoListener.onInfo(r15);
        }
    }
    onRenderingStart() {
        if (this.mOutOnRenderingStartListener != null) {
            this.mOutOnRenderingStartListener.onRenderingStart();
        }
    }
    onStateChanged(q15) {
        if (this.mOutOnStateChangedListener != null) {
            this.mOutOnStateChangedListener.onStateChanged(q15);
        }
    }
    onVideoSizeChanged(o15, p15) {
        if (this.mOutOnVideoSizeChangedListener != null) {
            this.mOutOnVideoSizeChangedListener.onVideoSizeChanged(o15, p15);
        }
    }
    onLoadingBegin() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(m15, n15) {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingProgress(m15, n15);
        }
    }
    onLoadingEnd() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingEnd();
        }
    }
    onSeekEnd() {
        if (this.mOutOnSeekCompleteListener != null) {
            this.mOutOnSeekCompleteListener.onSeekComplete();
        }
    }
    onCompletion() {
        if (this.mOutOnCompletionListener != null) {
            this.mOutOnCompletionListener.onCompletion();
        }
    }
    onVideoRendered(k15, l15) {
        if (this.mOutOnVideoRenderedListener != null) {
            this.mOutOnVideoRenderedListener.onVideoRendered(k15, l15);
        }
    }
    onSubtitleShow(h15, i15, j15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleShow(h15, i15, j15);
        }
    }
    onSubtitleExtAdded(f15, g15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleExtAdded(f15, g15);
        }
    }
    onSubtitleHide(d15, e15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHide(d15, e15);
        }
    }
    onSubtitleHeader(b15, c15) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHeader(b15, c15);
        }
    }
    onError(a15) {
        if (this.mOutOnErrorListener != null) {
            this.mOutOnErrorListener.onError(a15);
        }
    }
    onAudioInterruptEvent(z14) {
        if (this.mOutOnAudioInterruptEventListener != null) {
            this.mOutOnAudioInterruptEventListener.onAudioInterruptEvent(z14);
        }
    }
    onTrackReady(y14) {
        this.mOutMediaInfo = y14;
        if (this.mOutOnTrackReadyListener != null) {
            this.mOutOnTrackReadyListener.onTrackReady(y14);
        }
    }
    onSubTrackReady(x14) {
        this.mOutSubMediaInfo = x14;
        if (this.mOutOnSubTrackReadyListener != null) {
            this.mOutOnSubTrackReadyListener.onSubTrackReady(x14);
        }
    }
    onSwitchedSuccess(w14) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedSuccess(w14);
        }
    }
    onSwitchedFail(u14, v14) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedFail(u14, v14);
        }
    }
    onAVNotSyncStart(t14) {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncStart(t14);
        }
    }
    onAVNotSyncEnd() {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncEnd();
        }
    }
    onNetworkStats(s14) {
        if (this.mOutOnNetworkStatsListener != null) {
            this.mOutOnNetworkStatsListener.onNetworkStats(s14);
        }
    }
    onChangedSuccess(r14) {
        if (this.mOutOnTrackChangedListener != null) {
            this.mOutOnTrackChangedListener.onChangedSuccess(r14);
        }
    }
    onSnapShot(o14, p14, q14) {
        if (this.mOutOnSnapShotListener != null) {
            this.mOutOnSnapShotListener.onSnapShot(o14, p14, q14);
        }
    }
    onSeiData(m14, n14) {
        if (this.mOutOnSeiDataListener != null) {
            this.mOutOnSeiDataListener.onSeiData(m14, n14);
        }
    }
}
class InnerPrepareListener {
    constructor(l14) {
        this.avbBaseWR = l14;
    }
    onPrepared() {
        if (this.avbBaseWR != null) {
            this.avbBaseWR.onPrepared();
        }
    }
}
class InnerInfoListener {
    constructor(k14) {
        this.avpBaseRef = k14;
    }
    onInfo(j14) {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onInfo(j14);
        }
    }
}
class InnerRenderingStartListener {
    constructor(i14) {
        this.avpBaseRef = i14;
    }
    onRenderingStart() {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onRenderingStart();
        }
    }
}
class InnerStateChangedListener {
    constructor(h14) {
        this.avpBaseRef = h14;
    }
    onStateChanged(g14) {
        this.avpBaseRef.onStateChanged(g14);
    }
}
class InnerVideoSizeChangedListener {
    constructor(f14) {
        this.avpBaseRef = f14;
    }
    onVideoSizeChanged(d14, e14) {
        this.avpBaseRef.onVideoSizeChanged(d14, e14);
    }
}
class InnerLoadingStatusListener {
    constructor(c14) {
        this.avpBaseRef = c14;
    }
    onLoadingBegin() {
        this.avpBaseRef.onLoadingBegin();
    }
    onLoadingProgress(a14, b14) {
        this.avpBaseRef.onLoadingProgress(a14, b14);
    }
    onLoadingEnd() {
        this.avpBaseRef.onLoadingEnd();
    }
}
class InnerSeekCompleteListener {
    constructor(z13) {
        this.avpBaseRef = z13;
    }
    onSeekComplete() {
        this.avpBaseRef.onSeekEnd();
    }
}
class InnerCompletionListener {
    constructor(y13) {
        this.avpBaseRef = y13;
    }
    onCompletion() {
        this.avpBaseRef.onCompletion();
    }
}
class InnerVideoRenderedListener {
    constructor(x13) {
        this.avpBaseRef = x13;
    }
    onVideoRendered(v13, w13) {
        this.avpBaseRef.onVideoRendered(v13, w13);
    }
}
class InnerSubtitleDisplayListener {
    constructor(u13) {
        this.avpBaseRef = u13;
    }
    onSubtitleShow(r13, s13, t13) {
        this.avpBaseRef.onSubtitleShow(r13, s13, t13);
    }
    onSubtitleExtAdded(p13, q13) {
        this.avpBaseRef.onSubtitleExtAdded(p13, q13);
    }
    onSubtitleHide(n13, o13) {
        this.avpBaseRef.onSubtitleHide(n13, o13);
    }
    onSubtitleHeader(l13, m13) {
        this.avpBaseRef.onSubtitleHeader(l13, m13);
    }
}
class InnerErrorListener {
    constructor(k13) {
        this.avpBaseRef = k13;
    }
    onError(j13) {
        this.avpBaseRef.onError(j13);
    }
}
class InnerAudioInterruptEventListener {
    constructor(i13) {
        this.avpBaseRef = i13;
    }
    onAudioInterruptEvent(h13) {
        this.avpBaseRef.onAudioInterruptEvent(h13);
    }
}
class InnerTrackReadyListener {
    constructor(g13) {
        this.avpBaseRef = g13;
    }
    onTrackReady(f13) {
        this.avpBaseRef.onTrackReady(f13);
    }
}
class InnerSubTrackReadyListener {
    constructor(e13) {
        this.avpBaseRef = e13;
    }
    onSubTrackReady(d13) {
        this.avpBaseRef.onSubTrackReady(d13);
    }
}
class InnerStreamSwitchedListener {
    constructor(c13) {
        this.avpBaseRef = c13;
    }
    onSwitchedSuccess(b13) {
        this.avpBaseRef.onSwitchedSuccess(b13);
    }
    onSwitchedFail(z12, a13) {
        this.avpBaseRef.onSwitchedFail(z12, a13);
    }
}
class InnerOnAVNotSyncStatusListener {
    constructor(y12) {
        this.avpBaseRef = y12;
    }
    onAVNotSyncStart(x12) {
        this.avpBaseRef.onAVNotSyncStart(x12);
    }
    onAVNotSyncEnd() {
        this.avpBaseRef.onAVNotSyncEnd();
    }
}
class InnerOnNetworkStatsListener {
    constructor(w12) {
        this.avpBaseRef = w12;
    }
    onNetworkStats(v12) {
        this.avpBaseRef.onNetworkStats(v12);
    }
}
class InnerTrackChangedListener {
    constructor(u12) {
        this.avpBaseRef = u12;
    }
    onChangedSuccess(t12) {
        this.avpBaseRef.onChangedSuccess(t12);
    }
}
class InnerSnapShotListener {
    constructor(s12) {
        this.avpBaseRef = s12;
    }
    onSnapShot(p12, q12, r12) {
        this.avpBaseRef.onSnapShot(p12, q12, r12);
    }
}
class InnerSeiDataListener {
    constructor(o12) {
        this.avpBaseRef = o12;
    }
    onSeiData(m12, n12) {
        this.avpBaseRef.onSeiData(m12, n12);
    }
}
