import { UrlVideoListPlayer } from './UrlVideoListPlayer';
import { Log } from '../utils/Log';
import { ApsaraVideoPlayer } from './ApsaraVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
import { LiveSts } from './source/LiveSts';
import { VidSts } from './source/VidSts';
import { VidAuth } from './source/VidAuth';
import { VidMps } from './source/VidMps';
import { StsInfo } from './source/StsInfo';
import { OhosSaasListPlayer } from './nativeclass/OhosSaasListPlayer';
export class ApsaraVideoListPlayer extends UrlVideoListPlayer {
    constructor(u11, v11) {
        super(u11, v11);
        this.mmLog = new Log("NativePlayerBase_ApsaraVideListPlayer");
        this.mSaasVidePlayer = null;
        this.mSaaSPrerenderPlayer = null;
    }
    createListPlayer(q11, r11, s11, t11) {
        return new OhosSaasListPlayer(q11, s11, t11, true);
    }
    getNativePlayerWithContext(o11, p11) {
        if (this.mSaasVidePlayer == null) {
            this.mSaasVidePlayer = new ApsaraVideoPlayer(o11, p11);
        }
        return this.mSaasVidePlayer;
    }
    getPrerenderPlayerWithContext(m11, n11) {
        if (this.mSaaSPrerenderPlayer == null) {
            this.mSaaSPrerenderPlayer = new ApsaraVideoPlayer(m11, n11);
        }
        return this.mSaaSPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let l11 = super.getCorePlayer();
        if (l11 instanceof OhosUrlListPlayer) {
            this.mmLog.info("getCurrentPlayerIndex");
            return l11.getCurrentPlayerIndex();
        }
        return 0;
    }
    stop() {
        super.stop();
        let k11 = super.getCorePlayer();
        if (k11 instanceof OhosUrlListPlayer) {
            this.mmLog.info("stop");
            k11.stop();
        }
    }
    getPreRenderPlayer() {
        let i11 = super.getCorePlayer();
        if (i11 instanceof OhosUrlListPlayer) {
            this.mmLog.info("getPreRenderPlayer");
            let j11 = i11.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(j11);
        }
        return undefined;
    }
    setVidAuthDataSource(g11) {
        let h11 = super.getCorePlayer();
        if (h11 instanceof ApsaraVideoPlayer) {
            if (g11 instanceof VidAuth) {
                h11.setVidAuthDataSource(g11);
            }
        }
    }
    setVidStsDataSource(e11) {
        let f11 = super.getCorePlayer();
        if (f11 instanceof ApsaraVideoPlayer) {
            if (e11 instanceof VidSts) {
                f11.setVidStsDataSource(e11);
            }
        }
    }
    setVidMpsDataSource(c11) {
        let d11 = super.getCorePlayer();
        if (d11 instanceof ApsaraVideoPlayer) {
            if (c11 instanceof VidMps) {
                d11.setVidMpsDataSource(c11);
            }
        }
    }
    setLiveStsDataSource(a11) {
        let b11 = super.getCorePlayer();
        if (b11 instanceof ApsaraVideoPlayer) {
            if (a11 instanceof LiveSts) {
                b11.setLiveStsDataSource(a11);
            }
        }
    }
    updateVidAuth(y10) {
        let z10 = super.getCorePlayer();
        if (z10 instanceof ApsaraVideoPlayer) {
            if (y10 instanceof VidAuth) {
                z10.updateVidAuth(y10);
            }
        }
    }
    updateStsInfo(w10) {
        let x10 = super.getCorePlayer();
        if (x10 instanceof ApsaraVideoPlayer) {
            if (w10 instanceof StsInfo) {
                x10.updateStsInfo(w10);
            }
        }
    }
}
