import premierlibrary from 'libpremierlibrary.so';
export class HlsKeyGenerator {
    static getInstance() {
        if (HlsKeyGenerator.instance == undefined) {
            HlsKeyGenerator.instance = new HlsKeyGenerator();
        }
        return HlsKeyGenerator.instance;
    }
    static setOnKeyGenerateListener(x22) {
        HlsKeyGenerator.getInstance().mOnKeyGenerateListener = x22;
    }
    constructor() {
        this.mOutKey = "default-key";
        this.getHlsOutKey = () => {
            return HlsKeyGenerator.getInstance().mOutKey;
        };
        this.onHlsKeyInfoInit = (u22, v22, w22) => {
            console.log('onHlsKeyInfoInit called.');
            if (this.mOnKeyGenerateListener != null) {
                this.mOnKeyGenerateListener.onHlsKeyInfoInit(u22, v22, w22);
            }
        };
        this.getHlsKey = (r22, s22) => {
            console.log('ongetHlsKey called.');
            if (this.mOnKeyGenerateListener != null) {
                let t22 = this.mOnKeyGenerateListener.getHlsKey(r22, s22);
                this.mOutKey = t22;
                console.log("get hlsKey, key: " + t22);
                return t22;
            }
            return "";
        };
        this.getHlsKeyInternal = () => {
            if (this.mOutKey) {
                return this.mOutKey;
            }
            return "";
        };
        premierlibrary.nHlsGenConstruct(this);
    }
}
