export var PreloadOptionType;
(function (o35) {
    o35["RESOLUTION"] = "RESOLUTION";
    o35["BANDWIDTH"] = "BANDWIDTH";
    o35["QUALITY"] = "QUALITY";
    o35["NONE"] = "NONE";
})(PreloadOptionType || (PreloadOptionType = {}));
export class PreloadConfig {
    constructor(g35) {
        this.mPreloadDuration = 1000;
        this.mOptionType = PreloadOptionType.NONE;
        this.mOptionIntValue = 0;
        this.mOptionStringValue = '';
        this.nativeGetDefaultBandWidth = () => {
            let n35 = this.getDefaultBandWidth();
            return n35;
        };
        this.nativeGetDefaultResolution = () => {
            return this.getDefaultResolution();
        };
        this.nativeGetDefaultQuality = () => {
            return this.getDefaultQuality();
        };
        this.nativeGetDefaultType = () => {
            return this.getDefaultType().toString();
        };
        this.nativeGetDuration = () => {
            let m35 = this.getDuration();
            return this.getDuration();
        };
        if (g35 !== undefined) {
            this.mPreloadDuration = g35;
        }
    }
    getDuration() {
        return this.mPreloadDuration;
    }
    setDuration(f35) {
        this.mPreloadDuration = f35;
    }
    setDefaultResolution(e35) {
        this.mOptionType = PreloadOptionType.RESOLUTION;
        this.mOptionIntValue = e35;
        this.mOptionStringValue = '';
    }
    getDefaultResolution() {
        return (this.mOptionType === PreloadOptionType.RESOLUTION) ? this.mOptionIntValue : 0;
    }
    setDefaultBandWidth(d35) {
        this.mOptionType = PreloadOptionType.BANDWIDTH;
        this.mOptionIntValue = d35;
        this.mOptionStringValue = '';
    }
    getDefaultBandWidth() {
        return (this.mOptionType === PreloadOptionType.BANDWIDTH) ? this.mOptionIntValue : 0;
    }
    setDefaultQuality(c35) {
        this.mOptionType = PreloadOptionType.QUALITY;
        this.mOptionStringValue = c35;
        this.mOptionIntValue = 0;
    }
    getDefaultQuality() {
        return (this.mOptionType === PreloadOptionType.QUALITY) ? this.mOptionStringValue : '';
    }
    getDefaultType() {
        return this.mOptionType;
    }
}
