import { SourceBase } from './SourceBase';
import { Definition } from './Definition';
export class VidSourceBase extends SourceBase {
    constructor() {
        super();
        this.mPlayConfig = null;
        this.mOutputType = null;
        this.mStreamTypes = null;
        this.mResultType = null;
        this.mDigitalWatermarkType = null;
        this.nativeGetOutputTypeStr = () => {
            if (this.mOutputType == null) {
                return "";
            }
            else {
                return this.mOutputType.toString();
            }
        };
        this.nativeGetReAuthInfoStr = () => {
            return this.mReAuthInfo;
        };
        this.nativeGetResultTypeStr = () => {
            if (this.mResultType == null) {
                return "";
            }
            else {
                return this.mResultType;
            }
        };
        this.nativeGetStreamTypeStr = () => {
            if (this.mStreamTypes == null || this.mStreamTypes.size == 0) {
                return "";
            }
            let i42 = "";
            for (let j42 of this.mStreamTypes) {
                if (j42 != null) {
                    i42 += j42 + ",";
                }
            }
            if (i42.length > 0) {
                i42 = i42.slice(0, -1);
            }
            return i42;
        };
        this.nativeGetDefinitionStr = () => {
            if (this.mDefinitions == null || this.mDefinitions.length == 0) {
                return "";
            }
            if (this.mDefinitions.includes(Definition.DEFINITION_AUTO, 0)) {
                return Definition.DEFINITION_AUTO;
            }
            let g42 = "";
            for (let h42 of this.mDefinitions) {
                if (h42 != null) {
                    g42 += h42 + ",";
                }
            }
            if (g42.length > 0) {
                g42 = g42.slice(0, -1);
            }
            return g42;
        };
        this.nativeGetPlayerConfigStr = () => {
            if (this.mPlayConfig == null) {
                return "";
            }
            else {
                return this.mPlayConfig.genConfig();
            }
        };
        this.nativeGetFormatStr = () => {
            return this.getFormatStr();
        };
        this.nativeGetAuthTimeout = () => {
            return this.mAuthTimeout;
        };
        this.nativeGetTrace = () => {
            return this.mTrace;
        };
        this.nativeGetDigitalWatermarkTypeStr = () => {
            if (this.mDigitalWatermarkType == null) {
                return "";
            }
            else {
                return this.mDigitalWatermarkType.toString();
            }
        };
        this.mFormats = [];
        this.mDefinitions = [];
        this.mReAuthInfo = "";
        this.mAuthTimeout = 3600;
        this.mTrace = "";
    }
    getPlayerConfig() {
        if (this.mPlayConfig == null) {
            return "";
        }
        else {
            return this.mPlayConfig.genConfig();
        }
    }
    setPlayerConfig(v41) {
        this.mPlayConfig = v41;
    }
    getFormats() {
        return this.mFormats;
    }
    setFormats(u41) {
        this.mFormats = u41;
    }
    getFormatStr() {
        if (this.mFormats.length == 0) {
            return "";
        }
        let s41 = "";
        for (let t41 of this.mFormats) {
            if (t41 != null) {
                s41 += t41 + ",";
            }
        }
        if (s41.length > 0) {
            s41 = s41.slice(0, -1);
        }
        return s41;
    }
    setDefinition(r41) {
        this.mDefinitions = r41;
    }
    getOutputType() {
        return this.mOutputType;
    }
    setOutputType(q41) {
        this.mOutputType = q41;
    }
    setAuthTimeout(p41) {
        this.mAuthTimeout = p41;
    }
    setTrace(o41) {
        this.mTrace = o41;
    }
    setDigitalWatermarkType(n41) {
        this.mDigitalWatermarkType = n41;
    }
    getTrace() {
        return this.mTrace;
    }
    getDigitalWatermarkType() {
        return this.mDigitalWatermarkType;
    }
}
export var OutputType;
(function (m41) {
    m41["oss"] = "oss";
    m41["cdn"] = "cdn";
})(OutputType || (OutputType = {}));
export var StreamType;
(function (l41) {
    l41["video"] = "video";
    l41["audio"] = "audio";
})(StreamType || (StreamType = {}));
export var ResultType;
(function (k41) {
    k41["Single"] = "Single";
    k41["Multiple"] = "Multiple";
})(ResultType || (ResultType = {}));
export var DigitalWatermarkType;
(function (j41) {
    j41["TraceMark"] = "TraceMark";
    j41["CopyrightMark"] = "CopyrightMark";
})(DigitalWatermarkType || (DigitalWatermarkType = {}));
