import premierlibrary from 'libpremierlibrary.so';
import ACPM from "@acpm/acpm_ohos_pc";
import { getEnumValues } from '../player/bean/InfoCode';
export class PrivateService {
    constructor() {
        this.nOnPremiumLicenseVerifyCallback = (p45, q45, r45) => {
            let s45 = findPremiumBizTypeByValue(p45);
            let t45 = false;
            if (q45 == 0) {
                t45 = false;
            }
            else {
                t45 = true;
            }
            if (PrivateService.sOnPremiumLicenseVerifyCallback != null) {
                PrivateService.sOnPremiumLicenseVerifyCallback.onPremiumLicenseVerifyCallback(s45, t45, r45);
            }
        };
    }
    static getInstance() {
        if (PrivateService.sInstance == undefined) {
            PrivateService.sInstance = new PrivateService();
        }
        return PrivateService.sInstance;
    }
    static preInitService(k45) {
        ACPM.setup(k45);
        ACPM.getFunctionsBinder().forEach((m45, n45) => {
            premierlibrary.JSBind.bindFunction(n45, m45);
        });
        premierlibrary.nPreInitService();
    }
    static initService(f45, g45) {
        ACPM.setup(f45);
        ACPM.getFunctionsBinder().forEach((i45, j45) => {
            premierlibrary.JSBind.bindFunction(j45, i45);
        });
        premierlibrary.nInitService(g45);
    }
    static initServiceWithBytes(a45, b45) {
        ACPM.setup(a45);
        ACPM.getFunctionsBinder().forEach((d45, e45) => {
            premierlibrary.JSBind.bindFunction(e45, d45);
        });
        premierlibrary.nInitService_bytes(b45);
    }
    static setOnPremiumLicenseVerifyCallback(z44) {
        PrivateService.sOnPremiumLicenseVerifyCallback = z44;
        premierlibrary.nSetOnPremiumLicenseVerifyCallback(PrivateService.getInstance(), z44 != null);
    }
}
PrivateService.sOnPremiumLicenseVerifyCallback = null;
export var PremiumBizType;
(function (y44) {
    y44[y44["BizType_UNKNOW"] = 0] = "BizType_UNKNOW";
    y44[y44["MediaLoader"] = 101] = "MediaLoader";
    y44[y44["PreRenderOption"] = 102] = "PreRenderOption";
    y44[y44["PremiumAbrStrategy"] = 103] = "PremiumAbrStrategy";
    y44[y44["H265Adaptive"] = 104] = "H265Adaptive";
    y44[y44["DashSupport"] = 105] = "DashSupport";
    y44[y44["EXTSubtitle"] = 108] = "EXTSubtitle";
    y44[y44["H266Support"] = 109] = "H266Support";
})(PremiumBizType || (PremiumBizType = {}));
export function findPremiumBizTypeByValue(v44) {
    const w44 = getEnumValues(PremiumBizType);
    for (const x44 of w44) {
        if (x44 === v44) {
            return x44;
        }
    }
    return PremiumBizType.BizType_UNKNOW;
}
