import http from '@ohos.net.http';
import util from "@ohos.util";
export class HttpClientHelper {
    constructor(y46) {
        this.mReferer = null;
        this.urlRequest = null;
        this.mNetworkTimeout = HttpClientHelper.CONNECTION_TIMEOUT;
        this.mHttpProxy = null;
        this.mUserAgent = null;
        this.mCustomHeaders = [{}];
        this.mUrl = y46;
    }
    setRefer(x46) {
        this.mReferer = x46;
    }
    setTimeout(w46) {
        this.mNetworkTimeout = w46;
    }
    setHttpProxy(v46) {
        this.mHttpProxy = v46;
    }
    setUserAgent(u46) {
        this.mUserAgent = u46;
    }
    setCustomHeaders(t46) {
        this.mCustomHeaders = t46;
    }
    stop() {
        if (this.urlRequest != null) {
            setTimeout(() => {
                this.urlRequest?.destroy();
            }, 0);
        }
    }
    async doGet() {
        if (this.mUrl.startsWith("https://") || this.mUrl.startsWith("http://")) {
            this.urlRequest = http.createHttp();
        }
        else {
            return null;
        }
        if (this.urlRequest == null) {
            return null;
        }
        let f46 = [];
        if (this.mReferer != null) {
            f46.push({ 'Referer': this.mReferer });
        }
        if (this.mUserAgent != null) {
            f46.push({ 'User-Agent': this.mUserAgent });
        }
        if (this.mCustomHeaders.length > 0) {
            for (let r46 of this.mCustomHeaders) {
                if (r46 != null) {
                    f46.push(r46);
                }
            }
        }
        let g46 = "";
        let h46 = false;
        if (this.mHttpProxy != null) {
            g46 = this.mHttpProxy;
            h46 = true;
        }
        else {
            g46 = this.mUrl;
        }
        let i46 = {
            method: http.RequestMethod.GET,
            header: f46,
            connectTimeout: this.mNetworkTimeout,
            readTimeout: this.mNetworkTimeout,
            usingProxy: h46,
        };
        return new Promise((k46, l46) => {
            if (this.urlRequest == null) {
                k46(null);
                return;
            }
            this.urlRequest.request(g46, i46, (n46, o46) => {
                if (n46) {
                    console.error('error:' + JSON.stringify(n46));
                    this.urlRequest?.destroy();
                    k46(null);
                    return;
                }
                if (o46.responseCode == http.ResponseCode.OK) {
                    if (o46.resultType == http.HttpDataType.STRING) {
                        k46(o46.result);
                    }
                    else if (o46.resultType == http.HttpDataType.ARRAY_BUFFER) {
                        let p46 = util.TextDecoder.create('utf-8');
                        let q46 = p46.decodeToString(new Uint8Array(o46.result));
                        k46(q46 ? q46 : null);
                    }
                    else {
                        console.info("response failed, resultType: " + o46.resultType);
                        this.urlRequest?.destroy();
                        k46(null);
                    }
                }
                else {
                    console.info("response failed, responseCode is " + o46.responseCode);
                    this.urlRequest?.destroy();
                    k46(null);
                }
            });
        });
    }
}
HttpClientHelper.CONNECTION_TIMEOUT = 10000;
