import premierlibrary from 'libpremierlibrary.so';
export class Logger {
    constructor() {
        this.mValue = -1;
        this.mLogCallback = null;
        this.mEnableConsoleLog = true;
        this.mCurrentLogLevel = LogLevel.AF_LOG_LEVEL_INFO;
        this.nOnLogCallback = (t47, u47) => {
            let v47 = Logger.getLevel(t47);
            if (Logger.sAppContext != null) {
                Logger.getInstance(Logger.sAppContext).callback(v47, u47);
            }
        };
        premierlibrary.nLoggerConstruct(this);
    }
    static getInstance(r47) {
        if (Logger.sInstance == null) {
            Logger.sInstance = new Logger();
            Logger.sInstance.setLogLevel(LogLevel.AF_LOG_LEVEL_INFO);
            if (r47 != null) {
                Logger.sAppContext = r47;
            }
        }
        return Logger.sInstance;
    }
    setLogCallback(q47) {
        this.mLogCallback = q47;
    }
    getLogCallback() {
        return this.mLogCallback;
    }
    setLogLevel(p47) {
        this.mCurrentLogLevel = p47;
        premierlibrary.nLoggerSetLevel(p47);
    }
    setLogOption(n47, o47) {
        switch (n47) {
            case LogOption.FRAME_LEVEL_LOGGING_ENABLED:
                premierlibrary.nLoggerSetOption("frame_level_logging_enabled", o47);
                break;
        }
    }
    getLogLevel() {
        let m47 = premierlibrary.nLoggerGetLevel();
        return Logger.getLevel(m47);
    }
    enableConsoleLog(l47) {
        this.mEnableConsoleLog = l47;
        premierlibrary.nLoggerEnableConsole(l47);
    }
    callback(j47, k47) {
        if (this.mLogCallback != null) {
            this.mLogCallback.onLog(j47, k47);
        }
    }
    static getLevel(i47) {
        switch (i47) {
            case 0:
                return LogLevel.AF_LOG_LEVEL_NONE;
            case 8:
                return LogLevel.AF_LOG_LEVEL_FATAL;
            case 16:
                return LogLevel.AF_LOG_LEVEL_ERROR;
            case 24:
                return LogLevel.AF_LOG_LEVEL_WARNING;
            case 32:
                return LogLevel.AF_LOG_LEVEL_INFO;
            case 48:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
            case 56:
                return LogLevel.AF_LOG_LEVEL_TRACE;
            default:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
        }
    }
}
export var LogLevel;
(function (h47) {
    h47[h47["AF_LOG_LEVEL_NONE"] = 0] = "AF_LOG_LEVEL_NONE";
    h47[h47["AF_LOG_LEVEL_FATAL"] = 8] = "AF_LOG_LEVEL_FATAL";
    h47[h47["AF_LOG_LEVEL_ERROR"] = 16] = "AF_LOG_LEVEL_ERROR";
    h47[h47["AF_LOG_LEVEL_WARNING"] = 24] = "AF_LOG_LEVEL_WARNING";
    h47[h47["AF_LOG_LEVEL_INFO"] = 32] = "AF_LOG_LEVEL_INFO";
    h47[h47["AF_LOG_LEVEL_DEBUG"] = 48] = "AF_LOG_LEVEL_DEBUG";
    h47[h47["AF_LOG_LEVEL_TRACE"] = 56] = "AF_LOG_LEVEL_TRACE";
})(LogLevel || (LogLevel = {}));
export var LogOption;
(function (g47) {
    g47[g47["FRAME_LEVEL_LOGGING_ENABLED"] = 1] = "FRAME_LEVEL_LOGGING_ENABLED";
})(LogOption || (LogOption = {}));
