import { ALLOW_PRE_RENDER } from './IPlayer';
export class AVPLBase {
    constructor(s21, t21) {
        this.mNativePlayer = this.getNativePlayerWithContext(s21, t21);
        this.mPreRenderPlayer = this.getPrerenderPlayerWithContext(s21, t21);
        this.mListPlayer = this.createListPlayer(s21, t21, this.mNativePlayer.getNativeContextAddr(), this.mPreRenderPlayer.getNativeContextAddr());
    }
    getCurrentPlayer() {
        let r21 = this.getCurrentPlayerIndex();
        if (r21 == 1) {
            return this.mPreRenderPlayer;
        }
        else {
            return this.mNativePlayer;
        }
    }
    getCurrentPrerenderPlayer(q21) {
        if (q21 == 0) {
            return this.mNativePlayer;
        }
        else if (q21 == 1) {
            return this.mPreRenderPlayer;
        }
        return undefined;
    }
    getCorePlayer() {
        return this.mListPlayer;
    }
    getNativePlayer() {
        return this.mNativePlayer;
    }
    getPrerenderPlayer() {
        return this.mPreRenderPlayer;
    }
    removeSource(p21) {
        this.mListPlayer?.removeSource(p21);
    }
    clear() {
        this.mListPlayer?.clear();
    }
    getCurrentUid() {
        return this.mListPlayer?.getCurrentUid();
    }
    setMaxPreloadMemorySizeMB(o21) {
        this.mListPlayer?.setMaxPreloadMemorySizeMB(o21);
    }
    getMaxPreloadMemorySizeMB() {
        return this.mListPlayer?.getMaxPreloadMemorySizeMB();
    }
    SetMultiBitratesMode(n21) {
        this.mListPlayer?.SetMultiBitratesMode(n21);
    }
    GetMultiBitratesMode() {
        return this.mListPlayer?.GetMultiBitratesMode();
    }
    setPreloadCount(m21) {
        this.mListPlayer?.setPreloadCount(m21);
    }
    setPreloadScene(l21) {
        this.mListPlayer?.setPreloadScene(l21);
    }
    enablePreloadStrategy(j21, k21) {
        this.mListPlayer?.enablePreloadStrategy(j21, k21);
    }
    setPreloadStrategy(h21, i21) {
        this.mListPlayer?.setPreloadStrategyParam(h21, i21);
    }
    setPreloadCountWithPrevAndNext(f21, g21) {
        this.mListPlayer?.setPreloadCountWithPrevAndNext(f21, g21);
    }
    getNativeContextAddr() {
        return this.getCurrentPlayer()?.getNativeContextAddr();
    }
    prepare() {
        this.getCurrentPlayer().prepare();
    }
    start() {
        this.getCurrentPlayer()?.start();
    }
    pause() {
        this.getCurrentPlayer().pause();
    }
    stop() {
        this.getCurrentPlayer().stop();
    }
    setAutoPlay(e21) {
        this.getCurrentPlayer().setAutoPlay(e21);
    }
    setSurfaceId(d21) {
        this.getCurrentPlayer().setSurfaceId(d21);
    }
    setSpeed(c21) {
        this.getCurrentPlayer().setSpeed(c21);
    }
    setVolume(b21) {
        this.getCurrentPlayer().setVolume(b21);
    }
    getVolume() {
        return this.getCurrentPlayer().getVolume();
    }
    seekTo(z20, a21) {
        this.getCurrentPlayer().seekTo(z20, a21);
    }
    setStartTime(x20, y20) {
        this.getCurrentPlayer().setStartTime(x20, y20);
    }
    getDuration() {
        return this.getCurrentPlayer().getDuration();
    }
    getPlayedDuration() {
        return this.getCurrentPlayer().getPlayedDuration();
    }
    getCurrentPosition() {
        return this.getCurrentPlayer().getCurrentPosition();
    }
    getBufferedPosition() {
        return this.getCurrentPlayer().getBufferedPosition();
    }
    getPlayerStatus() {
        return this.getCurrentPlayer().getPlayerStatus();
    }
    enableHardwareDecoder(w20) {
        this.getCurrentPlayer().enableHardwareDecoder(w20);
    }
    release() {
        this.mListPlayer?.release();
        this.mNativePlayer?.release();
        this.mPreRenderPlayer?.release();
    }
    releaseAsync() {
        this.release();
    }
    setMute(v20) {
        this.getCurrentPlayer().setMute(v20);
    }
    isMuted() {
        return this.getCurrentPlayer().isMuted();
    }
    setScaleMode(u20) {
        this.getCurrentPlayer().setScaleMode(u20);
    }
    getScaleMode() {
        return this.getCurrentPlayer().getScaleMode();
    }
    setLoop(t20) {
        this.getCurrentPlayer().setLoop(t20);
    }
    isLoop() {
        return this.getCurrentPlayer().isLoop();
    }
    getVideoWidth() {
        return this.getCurrentPlayer().getVideoWidth();
    }
    getVideoHeight() {
        return this.getCurrentPlayer().getVideoHeight();
    }
    getVideoRotation() {
        return this.getCurrentPlayer().getVideoRotation();
    }
    reload() {
        this.getCurrentPlayer().reload();
    }
    setRotateMode(s20) {
        this.getCurrentPlayer().setRotateMode(s20);
    }
    getRotateMode() {
        return this.getCurrentPlayer().getRotateMode();
    }
    setMirrorMode(r20) {
        this.getCurrentPlayer().setMirrorMode(r20);
    }
    getMirrorMode() {
        return this.getCurrentPlayer().getMirrorMode();
    }
    setAlphaRenderMode(q20) {
        this.getCurrentPlayer().setAlphaRenderMode(q20);
    }
    getAlphaRenderMode() {
        return this.getCurrentPlayer().getAlphaRenderMode();
    }
    setVideoBackgroundColor(p20) {
        this.getCurrentPlayer().setVideoBackgroundColor(p20);
    }
    getSpeed() {
        return this.getCurrentPlayer().getSpeed();
    }
    isAutoPlay() {
        return this.getCurrentPlayer().isAutoPlay();
    }
    setConfig(o20) {
        if (this.mNativePlayer != null) {
            this.mNativePlayer.setConfig(o20);
        }
        if (this.mPreRenderPlayer != null) {
            this.mPreRenderPlayer.setConfig(o20);
        }
    }
    getConfig() {
        return this.getCurrentPlayer().getConfig();
    }
    setPlayerScene(n20) {
        this.getCurrentPlayer().setPlayerScene(n20);
    }
    setOption(l20, m20) {
        this.getCurrentPlayer().setOption(l20, m20);
    }
    setOptionNum(j20, k20) {
        this.getCurrentPlayer().setOptionNum(j20, k20);
        if (j20 == ALLOW_PRE_RENDER) {
            if (this.getCurrentPlayer() == this.mPreRenderPlayer) {
                this.mNativePlayer?.setOptionNum(j20, k20);
            }
            else {
                this.mPreRenderPlayer?.setOptionNum(j20, k20);
            }
        }
    }
    getOption(i20) {
        return this.getCurrentPlayer().getOption(i20);
    }
    selectTrack(h20) {
        this.getCurrentPlayer()?.selectTrack(h20);
    }
    switchStream(g20) {
        this.getCurrentPlayer()?.switchStream(g20);
    }
    getMediaInfo() {
        return this.getCurrentPlayer()?.getMediaInfo();
    }
    getSubMediaInfo() {
        return this.getCurrentPlayer()?.getSubMediaInfo();
    }
    currentTrack(f20) {
        return this.getCurrentPlayer()?.currentTrack(f20);
    }
    addExtSubtitle(e20) {
        this.getCurrentPlayer()?.addExtSubtitle(e20);
    }
    selectExtSubtitle(c20, d20) {
        this.getCurrentPlayer()?.selectExtSubtitle(c20, d20);
    }
    setStreamDelay(a20, b20) {
        this.getCurrentPlayer()?.setStreamDelay(a20, b20);
    }
    setMaxAccurateSeekDelta(z19) {
        this.getCurrentPlayer()?.setMaxAccurateSeekDelta(z19);
    }
    setCacheConfig(y19) {
        this.getCurrentPlayer()?.setCacheConfig(y19);
    }
    setIPResolveType(x19) {
        this.getCurrentPlayer()?.setIPResolveType(x19);
    }
    setFastStart(w19) {
        this.getCurrentPlayer()?.setFastStart(w19);
    }
    snapShot() {
        this.getCurrentPlayer()?.snapShot();
    }
    clearScreen() {
        this.getCurrentPlayer()?.clearScreen();
    }
    getCacheFilePathByUrl(v19) {
        return this.getCurrentPlayer()?.getCacheFilePathByUrl(v19) || '';
    }
    getCacheFilePathByVid(r19, s19, t19, u19) {
        return this.getCurrentPlayer()?.getCacheFilePathByVid(r19, s19, t19, u19) || '';
    }
    getPropertyString(q19) {
        return this.getCurrentPlayer()?.getPropertyString(q19) || '';
    }
    setDefaultBandWidth(p19) {
        this.getCurrentPlayer()?.setDefaultBandWidth(p19);
    }
    setDefaultResolution(o19) {
        this.getCurrentPlayer()?.setDefaultResolution(o19);
    }
    sendCustomEvent(n19) {
        this.getCurrentPlayer()?.sendCustomEvent(n19);
    }
    setVideoTag(m19) {
        this.getCurrentPlayer()?.setVideoTag(m19);
    }
    setUserData(l19) {
        this.getCurrentPlayer()?.setUserData(l19);
    }
    setTraceId(k19) {
        this.getCurrentPlayer()?.setTraceId(k19);
    }
    getUserData() {
        return this.getCurrentPlayer()?.getUserData() || '';
    }
    setOnPreparedListener(j19) {
        this.getCurrentPlayer().setOnPreparedListener(j19);
    }
    setOnInfoListener(i19) {
        this.getCurrentPlayer().setOnInfoListener(i19);
    }
    setOnRenderingStartListener(h19) {
        this.getCurrentPlayer().setOnRenderingStartListener(h19);
    }
    setOnStateChangedListener(g19) {
        this.getCurrentPlayer().setOnStateChangedListener(g19);
    }
    setOnCompletionListener(f19) {
        this.getCurrentPlayer().setOnCompletionListener(f19);
    }
    setOnLoadingStatusListener(e19) {
        this.getCurrentPlayer().setOnLoadingStatusListener(e19);
    }
    setOnAVNotSyncStatusListener(d19) {
        this.getCurrentPlayer()?.setOnAVNotSyncStatusListener(d19);
    }
    setOnNetworkStatsListener(c19) {
        this.getCurrentPlayer()?.setOnNetworkStatsListener(c19);
    }
    setOnErrorListener(b19) {
        this.getCurrentPlayer().setOnErrorListener(b19);
    }
    setOnVideoSizeChangedListener(a19) {
        this.getCurrentPlayer().setOnVideoSizeChangedListener(a19);
    }
    setOnSeekCompleteListener(z18) {
        this.getCurrentPlayer().setOnSeekCompleteListener(z18);
    }
    setOnSubtitleDisplayListener(y18) {
        this.getCurrentPlayer().setOnSubtitleDisplayListener(y18);
    }
    setOnVideoRenderedListener(x18) {
        this.getCurrentPlayer().setOnVideoRenderedListener(x18);
    }
    setOnAudioInterruptEventListener(w18) {
        this.getCurrentPlayer().setOnAudioInterruptEventListener(w18);
    }
    setOnSubTrackReadyListener(v18) {
        this.getCurrentPlayer()?.setOnSubTrackReadyListener(v18);
    }
    setOnTrackReadyListener(u18) {
        this.getCurrentPlayer()?.setOnTrackReadyListener(u18);
    }
    setOnTrackChangedListener(t18) {
        this.getCurrentPlayer()?.setOnTrackChangedListener(t18);
    }
    setOnSnapShotListener(s18) {
        this.getCurrentPlayer()?.setOnSnapShotListener(s18);
    }
    setOnSeiDataListener(r18) {
        this.getCurrentPlayer()?.setOnSeiDataListener(r18);
    }
    setOnStreamSwitchedListener(q18) {
        this.getCurrentPlayer()?.setOnStreamSwitchedListener(q18);
    }
}
