import premierlibrary from 'libpremierlibrary.so';
export class AliPlayerGlobalSettings {
    static getInstance() {
        if (AliPlayerGlobalSettings.sInstance == undefined) {
            AliPlayerGlobalSettings.sInstance = new AliPlayerGlobalSettings();
        }
        return AliPlayerGlobalSettings.sInstance;
    }
    constructor() {
        this.nOnGetUrlHashCallback = (k9) => {
            if (AliPlayerGlobalSettings.sOnGetUrlHashCallback != null) {
                return AliPlayerGlobalSettings.sOnGetUrlHashCallback.getUrlHashCallback(k9);
            }
            else {
                return null;
            }
        };
    }
    static OnGetUrlHashCallback(h9) {
        if (AliPlayerGlobalSettings.sOnGetUrlHashCallback != null) {
            let i9 = AliPlayerGlobalSettings.sOnGetUrlHashCallback.getUrlHashCallback(h9);
            if (i9 != undefined) {
                if (i9.length == 0) {
                    return AliPlayerGlobalSettings.FORBID_URLHASHCB;
                }
                else {
                    return i9;
                }
            }
            else {
                return AliPlayerGlobalSettings.FORBID_URLHASHCB;
            }
        }
        else {
            return AliPlayerGlobalSettings.FORBID_URLHASHCB;
        }
    }
    static OnGetUrlHashCallbackInternal(f9) {
        let g9 = AliPlayerGlobalSettings.OnGetUrlHashCallback(f9);
        if (g9.length == 0 || g9 == AliPlayerGlobalSettings.FORBID_URLHASHCB) {
            g9 = AliPlayerGlobalSettings.OnGetUrlRemovedQueryMd5(f9);
        }
        if (g9.length == 0) {
            g9 = AliPlayerGlobalSettings.FORBID_URLHASHCB;
        }
        return g9;
    }
    static OnGetUrlRemovedQueryMd5(e9) {
        if (AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5) {
            return premierlibrary.nGetUrlRemoveQueryMd5(e9);
        }
        return "";
    }
    static getSdkVersion() {
        return premierlibrary.nGetSdkVersion();
    }
    static setOptionStr(c9, d9) {
        premierlibrary.nSetOptionStr(c9, d9);
    }
    static setOptionNum(a9, b9) {
        premierlibrary.nSetOptionInt(a9, b9);
    }
    static setDNSResolve(y8, z8) {
        premierlibrary.nSetDNSResolve(y8, z8);
    }
    static setUseHttp2(x8) {
        premierlibrary.nSetUseHttp2(x8);
    }
    static setIPResolveType(w8) {
        premierlibrary.nGlobalSettingSetIPResolveType(w8);
    }
    static setAudioStreamType(v8) {
        premierlibrary.nSetAudioStreamType(v8);
    }
    static enableAudioLowLatencyMode(u8) {
        premierlibrary.nEnableAudioLowLatencyMode(u8);
    }
    static forceAudioRendingFormat(q8, r8, s8, t8) {
        premierlibrary.nForceAudioRendingFormat(q8, r8, s8, t8);
    }
    static enableLocalCache(n8, o8, p8) {
        return premierlibrary.nEnableLocalCache(n8, o8, p8);
    }
    static setCacheFileClearConfig(k8, l8, m8) {
        premierlibrary.nSetCacheFileClearConfig(k8, l8, m8);
    }
    static clearCaches() {
        premierlibrary.nClearCaches();
    }
    static enableHttpDns(j8) {
        premierlibrary.nEnableHttpDns(j8);
    }
    static enableEnhancedHttpDns(i8) {
        premierlibrary.nEnableEnhancedHttpDns(i8);
    }
    static enableNetworkBalance(h8) {
        premierlibrary.nEnableNetworkBalance(h8);
    }
    static enableBufferToLocalCache(g8) {
        premierlibrary.nEnableBufferToLocalCache(g8);
    }
    static disableCrashUpload(f8) {
        premierlibrary.nDisableCrashUpload(f8);
    }
    static setCacheUrlHashCallback(e8) {
        AliPlayerGlobalSettings.sOnGetUrlHashCallback = e8;
        AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5 = false;
        premierlibrary.nSetCacheUrlHashCallback(AliPlayerGlobalSettings.getInstance(), e8 != null);
    }
    static setUrlHashCallbackRemoveQueryAndMd5() {
        AliPlayerGlobalSettings.sOnGetUrlHashCallback = null;
        AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5 = true;
        premierlibrary.nSetUrlHashCallbackRemoveQueryAndMd5();
    }
}
AliPlayerGlobalSettings.SET_PRE_CONNECT_DOMAIN = 0;
AliPlayerGlobalSettings.SET_DNS_PRIORITY_LOCAL_FIRST = 1;
AliPlayerGlobalSettings.ENABLE_H2_MULTIPLEX = 2;
AliPlayerGlobalSettings.SET_EXTRA_DATA = 3;
AliPlayerGlobalSettings.ENABLE_ANDROID_DECODE_REUSE = 4;
AliPlayerGlobalSettings.NOT_PAUSE_WHEN_PREPARING = 5;
AliPlayerGlobalSettings.ALLOW_RTS_DEGRADE = 6;
AliPlayerGlobalSettings.ENABLE_DECODER_FAST_FIRST_FRAME = 7;
AliPlayerGlobalSettings.DISABLE_CAPTURE_SCALE = 8;
AliPlayerGlobalSettings.MAX_ERROR_FRAMES_HARDWARE_DECODE = 15;
AliPlayerGlobalSettings.SCENE_PLAYER = 0;
AliPlayerGlobalSettings.SCENE_LOADER = 1;
AliPlayerGlobalSettings.CodecType_H265 = 0;
AliPlayerGlobalSettings.FORBID_URLHASHCB = "forbid_UseUrlHashCb";
AliPlayerGlobalSettings.sOnGetUrlHashCallback = null;
AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5 = false;
export var AudioStreamType;
(function (d8) {
    d8[d8["AUDIOSTREAM_USAGE_UNKNOWN"] = 0] = "AUDIOSTREAM_USAGE_UNKNOWN";
    d8[d8["AUDIOSTREAM_USAGE_MUSIC"] = 1] = "AUDIOSTREAM_USAGE_MUSIC";
    d8[d8["AUDIOSTREAM_USAGE_VOICE_COMMUNICATION"] = 2] = "AUDIOSTREAM_USAGE_VOICE_COMMUNICATION";
    d8[d8["AUDIOSTREAM_USAGE_VOICE_ASSISTANT"] = 3] = "AUDIOSTREAM_USAGE_VOICE_ASSISTANT";
    d8[d8["AUDIOSTREAM_USAGE_ALARM"] = 4] = "AUDIOSTREAM_USAGE_ALARM";
    d8[d8["AUDIOSTREAM_USAGE_VOICE_MESSAGE"] = 5] = "AUDIOSTREAM_USAGE_VOICE_MESSAGE";
    d8[d8["AUDIOSTREAM_USAGE_RINGTONE"] = 6] = "AUDIOSTREAM_USAGE_RINGTONE";
    d8[d8["AUDIOSTREAM_USAGE_NOTIFICATION"] = 7] = "AUDIOSTREAM_USAGE_NOTIFICATION";
    d8[d8["AUDIOSTREAM_USAGE_ACCESSIBILITY"] = 8] = "AUDIOSTREAM_USAGE_ACCESSIBILITY";
    d8[d8["AUDIOSTREAM_USAGE_MOVIE"] = 10] = "AUDIOSTREAM_USAGE_MOVIE";
    d8[d8["AUDIOSTREAM_USAGE_GAME"] = 11] = "AUDIOSTREAM_USAGE_GAME";
    d8[d8["AUDIOSTREAM_USAGE_AUDIOBOOK"] = 12] = "AUDIOSTREAM_USAGE_AUDIOBOOK";
    d8[d8["AUDIOSTREAM_USAGE_NAVIGATION"] = 13] = "AUDIOSTREAM_USAGE_NAVIGATION";
    d8[d8["AUDIOSTREAM_USAGE_VIDEO_COMMUNICATION"] = 17] = "AUDIOSTREAM_USAGE_VIDEO_COMMUNICATION";
})(AudioStreamType || (AudioStreamType = {}));
