import { LiveTimeUpdater } from "../liveshift/LiveTimeUpdater";
import { AVPBase } from "./AVPBase";
import { OhosSaasPlayer } from "./nativeclass/OhosSaasPlayer";
import { UrlSource } from "./source/UrlSource";
import url from "@ohos.url";
import { prepared, started } from "../player/IPlayer";
const onTimeShiftUpdaterListenerMap = new WeakMap();
const liveOnPreparedListenerMap = new WeakMap();
const liveOnLoadingStatusListenerMap = new WeakMap();
const liveOnStateChangedListenerMap = new WeakMap();
export class ApsaraLiveShiftPlayer extends AVPBase {
    constructor(u10, v10) {
        super(u10, v10);
        this.status = -1;
        this.statusWhenSeek = -1;
        this.liveSeekToTime = -1;
        this.liveSeekOffset = -1;
        this.mLiveShiftSource = null;
        this.mLiveTimeUpdater = null;
        this.mOutOnTimeShiftUpdaterListener = null;
        this.mInnerOnTimeShiftUpdaterListener = new InnerTimeShiftUpdateListener(this);
        this.mOutLiveOnPreparedListener = null;
        this.mInnerLiveOnPreparedListener = new InnerLivePreparedListener(this);
        this.mOutLiveOnStateChangedListener = null;
        this.mInnerLiveOnStateChangedListener = new InnerLiveStateChangedListener(this);
        this.mOutLiveOnLoadingStatusListener = null;
        this.mInnerLiveOnLoadingStatusListener = new InnerLiveLoadingStatusListener(this);
        this.mOutLiveSeekLiveCompletionListener = null;
        onTimeShiftUpdaterListenerMap.set(this, this.mInnerOnTimeShiftUpdaterListener);
        liveOnPreparedListenerMap.set(this, this.mInnerLiveOnPreparedListener);
        liveOnLoadingStatusListenerMap.set(this, this.mInnerLiveOnLoadingStatusListener);
        liveOnStateChangedListenerMap.set(this, this.mInnerLiveOnStateChangedListener);
    }
    createAlivcMediaPlayer(s10) {
        let t10 = new OhosSaasPlayer(s10);
        return t10;
    }
    setLiveShiftDataSource(p10) {
        this.mLiveShiftSource = p10;
        let q10 = new UrlSource();
        q10.setUri(this.mLiveShiftSource.getUrl());
        let r10 = this.getCorePlayer();
        if (r10 instanceof OhosSaasPlayer) {
            r10.setUrlDataSource(q10);
        }
    }
    getCurrentLiveTime() {
        if (this.mLiveTimeUpdater) {
            return this.mLiveTimeUpdater.getLiveTime();
        }
        return 0;
    }
    getCurrentTime() {
        if (this.mLiveTimeUpdater) {
            return this.mLiveTimeUpdater.getPlayTime();
        }
        return 0;
    }
    seekToLiveTime(h10) {
        if (this.status == ApsaraLiveShiftPlayer.SeekLive) {
            return;
        }
        if (this.mLiveShiftSource == null) {
            return;
        }
        this.statusWhenSeek = this.status;
        this.status = ApsaraLiveShiftPlayer.SeekLive;
        this.liveSeekToTime = h10;
        this.liveSeekOffset = this.getCurrentLiveTime() - this.liveSeekToTime;
        if (this.liveSeekToTime < 0) {
            this.liveSeekToTime = 0;
            this.liveSeekToTime = this.getCurrentLiveTime();
        }
        let i10 = this.mLiveShiftSource?.getUrl();
        if (this.liveSeekToTime > 0 && this.liveSeekOffset > 0) {
            let j10 = url.URL.parseURL(i10);
            let k10 = new url.URLParams(j10.search);
            let l10 = k10.entries();
            let m10 = Array.from(l10);
            if (i10.endsWith("?") || i10.endsWith("&")) {
                i10 += ("lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
            }
            else {
                if (m10.length <= 0) {
                    i10 += ("?lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
                }
                else {
                    i10 += ("&lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
                }
            }
            let n10 = new UrlSource();
            n10.setUri(i10);
            let o10 = this.getCorePlayer();
            if (o10 instanceof OhosSaasPlayer) {
                o10.setUrlDataSource(n10);
                o10.prepare();
            }
        }
    }
    start() {
        super.start();
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.resumeUpdater();
        }
    }
    pause() {
        super.pause();
        this.mLiveTimeUpdater?.pauseUpdater();
    }
    stop() {
        super.stop();
        this.mLiveTimeUpdater?.stopUpdater();
    }
    onUpdater(e10, f10, g10) {
        console.info(ApsaraLiveShiftPlayer.tag + `onUpdater, currentTime: ${e10}, shiftStartTime: ${f10}, shiftEndTime: ${g10}`);
        if (this.mOutOnTimeShiftUpdaterListener) {
            this.mOutOnTimeShiftUpdaterListener.onUpdater(e10, f10, g10);
        }
    }
    onPrepared() {
        console.info(ApsaraLiveShiftPlayer.tag + " onPrepared");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.stopUpdater();
        }
        else {
            if (this.mLiveShiftSource) {
                this.mLiveTimeUpdater = new LiveTimeUpdater(this.mLiveShiftSource);
                this.mLiveTimeUpdater.setUpdaterListener(this.mInnerOnTimeShiftUpdaterListener);
            }
        }
        let d10 = this.getConfig();
        if (d10 != undefined) {
            this.mLiveTimeUpdater?.setConfig(d10);
            this.mLiveTimeUpdater?.setStartPlayTime(this.liveSeekToTime);
            this.mLiveTimeUpdater?.startUpdater();
        }
        if (this.status == ApsaraLiveShiftPlayer.SeekLive) {
            this.status = prepared;
            if (this.status == started) {
                this.start();
            }
            else {
                if (this.isAutoPlay()) {
                    this.mLiveTimeUpdater?.resumeUpdater();
                }
                else {
                    this.mLiveTimeUpdater?.pauseUpdater();
                }
            }
            if (this.mOutLiveSeekLiveCompletionListener != null) {
                console.info(ApsaraLiveShiftPlayer.tag + ` onSeekLiveCompletion, playTime: ${this.liveSeekToTime}`);
                this.mOutLiveSeekLiveCompletionListener.onSeekLiveCompletion(this.liveSeekToTime);
            }
            this.liveSeekToTime = -1;
        }
        else {
            this.status = prepared;
            if (this.mOutLiveOnPreparedListener != null) {
                this.mOutLiveOnPreparedListener.onPrepared();
            }
        }
    }
    onStateChanged(c10) {
        console.info(ApsaraLiveShiftPlayer.tag + " onStateChanged, newState: " + c10);
        if (c10 != prepared) {
            this.status = c10;
        }
        if (this.mOutLiveOnStateChangedListener != null) {
            this.mOutLiveOnStateChangedListener.onStateChanged(c10);
        }
    }
    onLoadingBegin() {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingBegin");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.pauseUpdater();
        }
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(a10, b10) {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingProgress, percent: " + a10);
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingProgress(a10, b10);
        }
    }
    onLoadingEnd() {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingEnd");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.resumeUpdater();
        }
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingEnd();
        }
    }
    setOnTimeShiftUpdaterListener(z9) {
        this.mOutOnTimeShiftUpdaterListener = z9;
    }
    setOnSeekLiveCompletionListener(y9) {
        this.mOutLiveSeekLiveCompletionListener = y9;
    }
    setOnStateChangedListener(x9) {
        this.mOutLiveOnStateChangedListener = x9;
        super.setOnStateChangedListener(this.mInnerLiveOnStateChangedListener);
    }
    setOnPreparedListener(w9) {
        this.mOutLiveOnPreparedListener = w9;
        super.setOnPreparedListener(this.mInnerLiveOnPreparedListener);
    }
    setOnLoadingStatusListener(v9) {
        this.mOutLiveOnLoadingStatusListener = v9;
        super.setOnLoadingStatusListener(this.mInnerLiveOnLoadingStatusListener);
    }
}
ApsaraLiveShiftPlayer.tag = "ApsaraLiveShiftPlayer";
ApsaraLiveShiftPlayer.SeekLive = 10;
class InnerTimeShiftUpdateListener {
    constructor(u9) {
        this.avPlayerRef = u9;
    }
    onUpdater(r9, s9, t9) {
        console.log(`currentTime: ${r9}}, shiftStartTime: ${s9}, shiftEndTime: ${t9} `);
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onUpdater(r9, s9, t9);
        }
    }
}
class InnerLivePreparedListener {
    constructor(q9) {
        this.avPlayerRef = q9;
    }
    onPrepared() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onPrepared();
        }
    }
}
class InnerLiveStateChangedListener {
    constructor(p9) {
        this.avPlayerRef = p9;
    }
    onStateChanged(o9) {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onStateChanged(o9);
        }
    }
}
class InnerLiveLoadingStatusListener {
    constructor(n9) {
        this.avPlayerRef = n9;
    }
    onLoadingBegin() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingBegin();
        }
    }
    onLoadingProgress(l9, m9) {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingProgress(l9, m9);
        }
    }
    onLoadingEnd() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingEnd();
        }
    }
    ;
}
