import { AVPLBase } from './AVPLBase';
import { Log } from '../utils/Log';
import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
export class UrlVideoListPlayer extends AVPLBase {
    constructor(b44, c44) {
        super(b44, c44);
        this.mLog = new Log("NativePlayerBase_UrlVideoListPlayer");
        this.mUrlVideoPlayer = null;
        this.mUrlPrerenderPlayer = null;
    }
    createListPlayer(x43, y43, z43, a44) {
        return new OhosUrlListPlayer(x43, z43, a44, false);
    }
    getNativePlayerWithContext(v43, w43) {
        if (this.mUrlVideoPlayer == null) {
            this.mUrlVideoPlayer = new UrlVideoPlayer(v43, w43);
        }
        return this.mUrlVideoPlayer;
    }
    getPrerenderPlayerWithContext(t43, u43) {
        if (this.mUrlPrerenderPlayer == null) {
            this.mUrlPrerenderPlayer = new UrlVideoPlayer(t43, u43);
        }
        return this.mUrlPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let s43 = super.getCorePlayer();
        if (s43 instanceof OhosUrlListPlayer) {
            this.mLog.info("getCurrentPlayerIndex");
            return s43.getCurrentPlayerIndex();
        }
        return -1;
    }
    getPreRenderPlayer() {
        let q43 = super.getCorePlayer();
        if (q43 instanceof OhosUrlListPlayer) {
            this.mLog.info("getPreRenderPlayer");
            let r43 = q43.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(r43);
        }
        return undefined;
    }
    addUrl(n43, o43) {
        let p43 = super.getCorePlayer();
        if (p43 instanceof OhosUrlListPlayer) {
            this.mLog.info("addUrl = " + n43 + " , uid = " + o43);
            p43.addUrl(n43, o43);
        }
    }
    moveToNext() {
        let m43 = super.getCorePlayer();
        if (m43 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNext");
            return m43.moveToNext(false);
        }
        return false;
    }
    moveToNextWithPrerendered() {
        let l43 = super.getCorePlayer();
        if (l43 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNextWithPrerendered");
            return l43.moveToNext(true);
        }
        return false;
    }
    moveToPrev() {
        let k43 = super.getCorePlayer();
        if (k43 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToPrev");
            return k43.moveToPrev();
        }
        return false;
    }
    moveTo(i43) {
        let j43 = super.getCorePlayer();
        if (j43 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveTo");
            return j43.moveTo(i43);
        }
        return false;
    }
    setUrlDataSource(g43) {
        let h43 = super.getNativePlayer();
        if (h43.setUrlDataSource !== undefined) {
            h43.setUrlDataSource(g43);
        }
    }
}
