import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
import { Option, AudioStatus, } from '../IPlayer';
import { InfoBean } from '../bean/InfoBean';
import { findInfoCodeByValue, InfoCode } from '../bean/InfoCode';
import { findErrorCodeByValue } from '../bean/PlayerErrorCode';
import { ErrorInfo } from '../bean/ErrorInfo';
import { ObjCreateHelper } from '../../utils/ObjCreateHelper';
import { findNetworkLevelByCode } from './NetworkStats';
const log = new Log('NativePlayerBase');
export class NativePlayerBase {
    constructor(a28) {
        this.mNativeContext = BigInt(0);
        this.objHelper = new ObjCreateHelper();
        this.getNativeContext = () => {
            log.info(`getNativeContext, address: ${this.mNativeContext}`);
            return this.mNativeContext;
        };
        this.setNativeContext = (q31) => {
            log.info(`[addr check] setNativeContext, address: ${q31}`);
            this.mNativeContext = q31;
        };
        this.getHelper = () => {
            log.info(`getHelper`);
            return this.objHelper;
        };
        this.getContext = () => {
            log.info(`[addr check] getNativeContext, address: ${this.mNativeContext}`);
            return this.mContext;
        };
        this.onPrepared = () => {
            console.log('onPrepared called at nativePlayerBase.');
            if (this.mOnPreparedListener != null) {
                this.setOption('InOnPrepared', '1');
                this.mOnPreparedListener.onPrepared();
                this.setOption('InOnPrepared', '0');
            }
        };
        this.onCircleStart = () => {
            if (this.mOnInfoListener != null) {
                let p31 = new InfoBean();
                p31.setCode(InfoCode.LoopingStart);
                this.mOnInfoListener.onInfo(p31);
            }
        };
        this.onAutoPlayStart = () => {
            if (this.mOnInfoListener != null) {
                let o31 = new InfoBean();
                o31.setCode(InfoCode.AutoPlayStart);
                this.mOnInfoListener.onInfo(o31);
            }
        };
        this.onEvent = (k31, l31) => {
            if (this.mOnInfoListener != null) {
                let m31 = findInfoCodeByValue(k31);
                let n31 = new InfoBean();
                n31.setCode(m31);
                n31.setExtraMsg(l31);
                this.mOnInfoListener.onInfo(n31);
            }
        };
        this.onCurrentDownloadSpeed = (i31) => {
            if (this.mOnInfoListener != null) {
                let j31 = new InfoBean();
                j31.setCode(InfoCode.CurrentDownloadSpeed);
                j31.setExtraValue(i31);
                this.mOnInfoListener.onInfo(j31);
            }
        };
        this.onUtcTimeUpdate = (g31) => {
            if (this.mOnInfoListener != null) {
                let h31 = new InfoBean();
                h31.setCode(InfoCode.UtcTime);
                h31.setExtraValue(g31);
                this.mOnInfoListener.onInfo(h31);
            }
        };
        this.onLocalCacheLoad = (e31) => {
            if (this.mOnInfoListener != null) {
                let f31 = new InfoBean();
                f31.setCode(InfoCode.LocalCacheLoaded);
                f31.setExtraValue(e31);
                this.mOnInfoListener.onInfo(f31);
            }
        };
        this.onBufferedPositionUpdate = (c31) => {
            if (this.mOnInfoListener != null) {
                let d31 = new InfoBean();
                d31.setCode(InfoCode.BufferedPosition);
                d31.setExtraValue(c31);
                this.mOnInfoListener.onInfo(d31);
            }
        };
        this.onCurrentPositionUpdate = (a31) => {
            if (this.mOnInfoListener != null) {
                let b31 = new InfoBean();
                b31.setCode(InfoCode.CurrentPosition);
                b31.setExtraValue(a31);
                this.mOnInfoListener.onInfo(b31);
            }
        };
        this.onFirstFrameShow = () => {
            if (this.mOnRenderingStartListener != null) {
                this.mOnRenderingStartListener.onRenderingStart();
            }
        };
        this.onVideoSizeChanged = (y30, z30) => {
            if (this.mOnVideoSizeChangedListener != null) {
                this.mOnVideoSizeChangedListener.onVideoSizeChanged(y30, z30);
            }
        };
        this.onAudioInterruptEvent = (x30) => {
            if (this.mOnAudioInterruptEventListener != null) {
                if (x30 < AudioStatus.AUDIO_STATUS_DEFAULT || x30 > AudioStatus.AUDIO_STATUS_UNDUCK) {
                    log.info('onAudioInterruptEvent exception audioStatus: ' + x30);
                    this.mOnAudioInterruptEventListener.onAudioInterruptEvent(AudioStatus.AUDIO_STATUS_DEFAULT);
                    return;
                }
                this.mOnAudioInterruptEventListener.onAudioInterruptEvent(x30);
            }
        };
        this.onLoadingStart = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingBegin();
            }
        };
        this.onLoadingProgress = (w30) => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingProgress(w30, 0);
            }
        };
        this.onLoadingEnd = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingEnd();
            }
        };
        this.onAVNotSyncStart = (v30) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncStart(v30);
            }
        };
        this.onAVNotSyncEnd = (u30) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncEnd();
            }
        };
        this.onNetworkStats = (r30, s30) => {
            let t30 = findNetworkLevelByCode(s30);
            r30.networkLevel = t30;
            if (this.mOnNetworkStatsListener != null) {
                this.mOnNetworkStatsListener.onNetworkStats(r30);
            }
        };
        this.onSeekEnd = () => {
            if (this.mOnSeekCompleteListener != null) {
                this.mOnSeekCompleteListener.onSeekComplete();
            }
        };
        this.onStatusChanged = (p30, q30) => {
            log.info('onStatusChanged, newState: ' + p30 + ' oldState: ' + q30);
            if (this.mOnStateChangedListener != null) {
                this.mOnStateChangedListener.onStateChanged(p30);
            }
        };
        this.onCompletion = () => {
            if (this.mOnCompletionListener != null) {
                this.mOnCompletionListener.onCompletion();
            }
        };
        this.onVideoRendered = (n30, o30) => {
            if (this.mOnVideoRenderedListener != null) {
                this.mOnVideoRenderedListener.onVideoRendered(n30, o30);
            }
        };
        this.onShowSubtitle = (k30, l30, m30) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleShow(k30, l30, m30);
            }
        };
        this.onSubtitleExtAdded = (i30, j30) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleExtAdded(i30, j30);
            }
        };
        this.onHideSubtitle = (g30, h30) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHide(g30, h30);
            }
        };
        this.onSubtitleHeader = (e30, f30) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHeader(e30, f30);
            }
        };
        this.onError = (z29, a30, b30) => {
            let c30 = findErrorCodeByValue(z29);
            if (this.mOnErrorListener != null) {
                let d30 = new ErrorInfo();
                d30.setCode(c30);
                d30.setMsg(a30);
                d30.setExtra(b30);
                this.mOnErrorListener.onError(d30);
            }
        };
        this.onStreamSwitchSuc = (y29) => {
            if (this.mOnTrackChangedListener != null) {
                this.mOnTrackChangedListener.onChangedSuccess(y29);
            }
        };
        this.onStreamInfoGet = (x29) => {
            if (this.mOnTrackReadyListener != null) {
                this.mOnTrackReadyListener.onTrackReady(x29);
            }
        };
        this.onSubStreamInfoGet = (w29) => {
            if (this.mOnSubTrackReadyListener != null) {
                this.mOnSubTrackReadyListener.onSubTrackReady(w29);
            }
        };
        this.onSwitchStreamUrlResult = (r29, s29, t29) => {
            if (this.mOnStreamSwitchedListener == null) {
                return;
            }
            if (s29 == 0) {
                this.mOnStreamSwitchedListener.onSwitchedSuccess(r29);
            }
            else {
                let u29 = findErrorCodeByValue(s29);
                let v29 = new ErrorInfo();
                v29.setCode(u29);
                v29.setMsg(t29);
                this.mOnStreamSwitchedListener.onSwitchedFail(r29, v29);
            }
        };
        this.onCaptureScreen = (o29, p29, q29) => {
            if (this.mOnSnapShotListener != null) {
                this.mOnSnapShotListener.onSnapShot(q29, o29, p29);
            }
        };
        this.onSeiDataCallback = (m29, n29) => {
            if (this.mOnSeiDataListener != null) {
                this.mOnSeiDataListener.onSeiData(m29, new Uint8Array(n29));
            }
        };
        log.info('constructor_');
        this.mContext = a28;
        premierlibrary.nConstruct(this);
    }
    setOnPreparedListener(z27) {
        this.mOnPreparedListener = z27;
    }
    setOnInfoListener(y27) {
        this.mOnInfoListener = y27;
    }
    setOnRenderingStartListener(x27) {
        this.mOnRenderingStartListener = x27;
    }
    setOnStateChangedListener(w27) {
        this.mOnStateChangedListener = w27;
    }
    setOnCompletionListener(v27) {
        this.mOnCompletionListener = v27;
    }
    setOnLoadingStatusListener(u27) {
        this.mOnLoadingStatusListener = u27;
    }
    setOnErrorListener(t27) {
        this.mOnErrorListener = t27;
    }
    setOnVideoSizeChangedListener(s27) {
        this.mOnVideoSizeChangedListener = s27;
    }
    setOnSeekCompleteListener(r27) {
        this.mOnSeekCompleteListener = r27;
    }
    setOnSubtitleDisplayListener(q27) {
        this.mOnSubtitleDisplayListener = q27;
    }
    setOnVideoRenderedListener(p27) {
        this.mOnVideoRenderedListener = p27;
    }
    setOnAudioInterruptEventListener(o27) {
        this.mOnAudioInterruptEventListener = o27;
    }
    setOnTrackReadyListener(n27) {
        this.mOnTrackReadyListener = n27;
    }
    setOnSubTrackReadyListener(m27) {
        this.mOnSubTrackReadyListener = m27;
    }
    setOnStreamSwitchedListener(l27) {
        this.mOnStreamSwitchedListener = l27;
    }
    setOnAVNotSyncStatusListener(k27) {
        this.mOnAVNotSyncStatusListener = k27;
    }
    setOnNetworkStatsListener(j27) {
        this.mOnNetworkStatsListener = j27;
    }
    setOnTrackChangedListener(i27) {
        this.mOnTrackChangedListener = i27;
    }
    setOnSnapShotListener(h27) {
        this.mOnSnapShotListener = h27;
    }
    setOnSeiDataListener(g27) {
        this.mOnSeiDataListener = g27;
    }
    start() {
        log.info('nStart');
        premierlibrary.nStart(this);
    }
    pause() {
        log.info('nPause');
        premierlibrary.nPause(this);
    }
    stop() {
        log.info('nStop');
        premierlibrary.nStop(this);
    }
    prepare() {
        log.info('nPrepare');
        premierlibrary.nPrepare(this);
    }
    setAutoPlay(f27) {
        log.info('nPrepare');
        premierlibrary.nSetAutoPlay(this, f27);
    }
    setSurfaceId(e27) {
        log.info('nSetSurfaceId');
        premierlibrary.nSetSurfaceId(this, e27);
    }
    setSpeed(d27) {
        log.info('setSpeed');
        premierlibrary.nSetSpeed(this, d27);
    }
    switchStream(c27) {
        log.info('switchStream');
        premierlibrary.nSwitchStream(this, c27);
    }
    setAlphaRenderMode(b27) {
        log.info('setAlphaRenderMode');
        premierlibrary.nSetAlphaRenderMode(this, b27);
    }
    getAlphaRenderMode() {
        log.info('getAlphaRenderMode');
        return premierlibrary.nGetAlphaRenderMode(this);
    }
    selectTrack(a27) {
        log.info('selectTrack');
        premierlibrary.nSelectTrack(this, a27);
    }
    getCurrentTrack(y26) {
        log.info('getCurrentTrack, type: ' + y26);
        let z26 = premierlibrary.nGetCurrentStreamInfo(this, y26);
        return z26;
    }
    addExtSubtitle(x26) {
        log.info(`addExtSubtitle`);
        premierlibrary.nAddExtSubtitle(this, x26);
    }
    selectExtSubtitle(v26, w26) {
        log.info(`selectExtSubtitle`);
        premierlibrary.nSelectExtSubtitle(this, v26, w26);
    }
    setVolume(u26) {
        log.info('setVolume');
        premierlibrary.nSetVolume(this, u26);
    }
    getVolume() {
        log.info('getVolume');
        return premierlibrary.nGetVolume(this);
    }
    seekTo(s26, t26) {
        log.info('seekTo');
        premierlibrary.nSeekTo(this, s26, t26);
    }
    setStartTime(q26, r26) {
        log.info('setStartTime');
        premierlibrary.nSetStartTime(this, q26, r26);
    }
    getDuration() {
        log.info('getDuration');
        return premierlibrary.nGetDuration(this);
    }
    setGlobalTime(p26) {
        premierlibrary.nSetGlobalTime(this, p26);
    }
    getPlayedDuration() {
        log.info('getPlayedDuration');
        return premierlibrary.nGetPlayedDuration(this);
    }
    getCurrentPosition() {
        log.info('getCurrentPosition');
        return premierlibrary.nGetCurrentPosition(this);
    }
    getBufferedPosition() {
        log.info('getBufferedPosition');
        return premierlibrary.nGetBufferedPosition(this);
    }
    getPlayerStatus() {
        log.info('getPlayerStatus');
        return premierlibrary.nGetPlayerStatus(this);
    }
    setTraceId(o26) {
        log.info('setTraceId');
        premierlibrary.nSetTraceId(this, o26);
    }
    enableHardwareDecoder(n26) {
        log.info('enableHardwareDecoder');
        premierlibrary.nEnableHardwareDecoder(this, n26);
    }
    release() {
        log.info('release');
        premierlibrary.nRelease(this);
    }
    setMute(m26) {
        log.info('setMute');
        premierlibrary.nSetMute(this, m26);
    }
    isMuted() {
        log.info('isMuted');
        return premierlibrary.nIsMuted(this) === 1;
    }
    setScaleMode(l26) {
        log.info('setScaleMode');
        premierlibrary.nSetScaleMode(this, l26);
    }
    getScaleMode() {
        log.info('getScaleMode');
        return premierlibrary.nGetScaleMode(this);
    }
    setLoop(k26) {
        log.info('setLoop');
        premierlibrary.nSetLoop(this, k26);
    }
    isLoop() {
        log.info('isLoop');
        return premierlibrary.nIsLoop(this) === 1;
    }
    getVideoWidth() {
        log.info('getVideoWidth');
        return premierlibrary.nGetVideoWidth(this);
    }
    getVideoHeight() {
        log.info('getVideoHeight');
        return premierlibrary.nGetVideoHeight(this);
    }
    getVideoRotation() {
        log.info('getVideoRotation');
        return premierlibrary.nGetVideoRotation(this);
    }
    reload() {
        log.info('reload');
        premierlibrary.nReload(this);
    }
    setRotateMode(j26) {
        log.info('setRotateMode');
        premierlibrary.nSetRotateMode(this, j26);
    }
    getRotateMode() {
        log.info('getRotateMode');
        return premierlibrary.nGetRotateMode(this);
    }
    setMirrorMode(i26) {
        log.info('setMirrorMode');
        premierlibrary.nSetMirrorMode(this, i26);
    }
    getMirrorMode() {
        log.info('getMirrorMode');
        return premierlibrary.nGetMirrorMode(this);
    }
    setVideoBackgroundColor(h26) {
        log.info('setVideoBackgroundColor');
        premierlibrary.nSetVideoBackgroundColor(this, h26);
    }
    getSpeed() {
        log.info('getSpeed');
        return premierlibrary.nGetSpeed(this);
    }
    isAutoPlay() {
        log.info('isAutoPlay');
        return premierlibrary.nIsAutoPlay(this) === 1;
    }
    setConfig(g26) {
        log.info('setConfig');
        premierlibrary.nSetConfig(this, g26);
        this.mPlayerConfig = g26;
    }
    getConfig() {
        log.info('getConfig');
        let f26 = premierlibrary.nGetConfig(this);
        return f26;
    }
    setPlayerScene(e26) {
        log.info('setPlayerScene');
        premierlibrary.nSetPlayerScene(this, e26);
    }
    setOption(c26, d26) {
        log.info('setOption');
        premierlibrary.nSetOption(this, c26, d26);
    }
    getOption(z25) {
        let a26 = premierlibrary.nGetOption(this, z25);
        if (z25 == Option.RenderFPS ||
            z25 == Option.DownloadBitrate ||
            z25 == Option.VideoBitrate ||
            z25 == Option.AudioBitrate) {
            let b26 = parseFloat(a26);
            return b26;
        }
        return a26;
    }
    setStreamDelay(x25, y25) {
        log.info('setStreamDelay');
        premierlibrary.nSetStreamDelay(this, x25, y25);
    }
    setMaxAccurateSeekDelta(w25) {
        log.info('setMaxAccurateSeekDelta');
        premierlibrary.nSetMaxAccurateSeekDelta(this, w25);
    }
    setCacheConfig(v25) {
        log.info('setCacheConfig');
        premierlibrary.nSetCacheConfig(this, v25);
    }
    setIPResolveType(u25) {
        log.info('setIPResolveType');
        premierlibrary.nSetIPResolveType(this, u25);
    }
    setFastStart(t25) {
        log.info('setFastStart');
        premierlibrary.nSetFastStart(this, t25);
    }
    snapShot() {
        log.info('snapShot');
        premierlibrary.nSnapShot(this);
    }
    clearScreen() {
        log.info('clearScreen');
        premierlibrary.nClearScreen(this);
    }
    getSdkVersion() {
        log.info('getSdkVersion');
        return premierlibrary.nGetSdkVersion();
    }
    getCacheFilePathByUrl(s25) {
        log.info('getCacheFilePathByUrl');
        return premierlibrary.nGetCacheFilePathByUrl(this, s25);
    }
    getCacheFilePathByVid(o25, p25, q25, r25) {
        log.info('getCacheFilePathByVid');
        return premierlibrary.nGetCacheFilePathByVid(this, o25, p25, q25, r25);
    }
    getPropertyString(n25) {
        log.info('getPropertyString');
        return premierlibrary.nGetPropertyString(this, n25);
    }
    setDefaultBandWidth(m25) {
        log.info('setDefaultBandWidth');
        premierlibrary.nSetDefaultBandWidth(this, m25);
    }
    setDefaultResolution(l25) {
        log.info('setDefaultResolution');
        premierlibrary.nSetDefaultResolution(this, l25);
    }
    sendCustomEvent(k25) {
        log.info('sendCustomEvent');
        premierlibrary.nSendCustomEvent(this, k25);
    }
    setVideoTag(j25) {
        log.info('setVideoTag');
        premierlibrary.nSetVideoTag(this, j25);
    }
    setUserData(i25) {
        log.info('setUserData');
        premierlibrary.nSetUserData(this, i25);
    }
    getUserData() {
        log.info('getUserData');
        return premierlibrary.nGetUserData(this);
    }
    getNativeContextAddr() {
        return this.mNativeContext;
    }
}
