export class BaseRequest {
    constructor(b46) {
        this.wantStop = false;
        this.outerListener = null;
        this.outerListener = b46;
    }
    getSync() {
        this.runInBackground();
    }
    getAsync() {
        this.runInBackgroundAsync();
    }
    runInBackgroundAsync() {
        setTimeout(() => {
            this.runInBackground();
        }, 0);
    }
    stop() {
        this.wantStop = true;
        this.stopInner();
    }
    sendSuccessResult(y45, z45) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onSuccess(y45, z45);
        }
    }
    sendFailResult(v45, w45, x45) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onFail(v45, w45, x45);
        }
    }
    dealMsg(u45) {
        if (u45.id == BaseRequest.WHAT_SUCCESS) {
            this.outerListener?.onSuccess(u45.data, u45.extra);
        }
        else if (u45.id == BaseRequest.WHAT_FAIL) {
            this.outerListener?.onFail(u45.failCode, u45.data, u45.extra);
        }
    }
}
BaseRequest.WHAT_SUCCESS = 1;
BaseRequest.WHAT_FAIL = 0;
BaseRequest.DATA_KEY_EXTRA = "data_extra";
