"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function chunk(arr, size) {
    if (size === void 0) { size = 1; }
    if (!size || size <= 0) {
        return [];
    }
    var intSize = Math.floor(size);
    var length = arr.length;
    var position = 0;
    var result = [];
    while (position + intSize <= length) {
        result.push(arr.slice(position, position + intSize));
        position += intSize;
    }
    if (position <= length - 1) {
        result.push(arr.slice(position, length));
    }
    return result;
}
exports.default = chunk;
