"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.arraySort = void 0;
var getValue_1 = __importDefault(require("./getValue"));
var identity_1 = __importDefault(require("../identity"));
var ascComparator_1 = __importDefault(require("./ascComparator"));
function arraySort(collection, iterates, ods) {
    var itFunctions;
    if (iterates.length > 0) {
        // @ts-ignore
        itFunctions = iterates.map(function (iterate) {
            if (Array.isArray(iterate)) {
                return function (value) { return (0, getValue_1.default)(value, iterate); };
            }
            if (typeof iterate === 'function') {
                return iterate;
            }
            if (typeof iterate === 'object' || typeof iterate === 'string') {
                return function (value) { return (0, getValue_1.default)(value, [iterate]); };
            }
            return identity_1.default;
        });
    }
    else {
        itFunctions = [identity_1.default];
    }
    /*
     * Array#sort(fn) 方法，会默认将 undefined 值不纳入计算排序，而是默认放在最后（升序场景），
     * 所以此处要额外处理，将原集合编辑成一个非空数组进行排序，以规避计算过程中自动跳过 undefined 值的场景。
     */
    var result = [];
    var len = collection.length;
    for (var i = 0; i < len; i++) {
        result.push({
            value: collection[i],
            index: i,
        });
    }
    result.sort(function (a, b) {
        var sortNums = itFunctions.map(function (func, index) {
            var order = ods[index] ? ods[index] : 'asc';
            var compareResult;
            if (typeof order === 'function') {
                compareResult = order(func(a.value), func(b.value));
            }
            else {
                var va = func(a.value);
                var vb = func(b.value);
                compareResult = (0, ascComparator_1.default)(va, vb);
            }
            // 反序
            if (order.toString() === 'desc') {
                compareResult = 0 - compareResult;
            }
            return compareResult;
        });
        return calcResult(sortNums);
    });
    var finalResult = [];
    for (var i = 0; i < len; i++) {
        finalResult[i] = result[i].value;
    }
    return finalResult;
}
exports.arraySort = arraySort;
function calcResult(nums) {
    var len = nums.length;
    for (var i = 0; i < len; i++) {
        if (nums[i] === 0) {
            continue;
        }
        return nums[i];
    }
    return 0;
}
