/**
 * 对指定的集合中的数据进行排序，并且返回一个新的数组。
 * 可以指定排序的字段，以及排序的方式（asc | desc）。
 * 此方法执行后，不影响原始 collection 中的顺序。
 * @Catalog Lang
 * @param collection 遍历排序的对象集合
 * @param iterate 排序的字段或者对象，支持多字段进行排序
 * @param orders 排序规则 （asc | desc）
 * @example
 * const users = [
 *   { 'user': 'fred',   'age': 48 },
 *   { 'user': 'barney', 'age': 34 },
 *   { 'user': 'fred',   'age': 40 },
 *   { 'user': 'barney', 'age': 36 }
 * ]
 *
 * // Sort by `user` in ascending order and by `age` in descending order.
 * orderBy(users, ['user', 'age'], ['asc', 'desc'])
 * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
 *
 * // Sort by `user` then by `age` using custom compare functions for each
 * orderBy(users, ['user', 'age'], [
 *   (a, b) => a.localeCompare(b, 'de', { sensitivity: 'base' }),
 *   (a, b) => a - b,
 * ])
 */
export default function orderBy(collection: any[] | Object, iterate: string[][] | Function[] | Object[] | string[] | string, orders?: (string | Function)[] | (string | Function)): any[];
