"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var identity_1 = __importDefault(require("./identity"));
var isNaN_1 = __importDefault(require("./isNaN"));
var isNil_1 = __importDefault(require("./isNil"));
/**
 * 调用 iteratee n 次，每次调用返回的结果存入到数组中。 iteratee 调用入1个参数： (index)。
 *
 * @since 1.0.0
 * @param n (number): 调用 iteratee 的次数。
 * @param iteratee (Function): 每次迭代调用的函数。接受一个参数 index
 * @returns (Array): 返回调用结果的数组。
 * @example
 * _.times(3, String);
 * // => ['0', '1', '2']
 *
 *  _.times(4, _.constant(0));
 * // => [0, 0, 0, 0]
 */
function times(n, iteratee) {
    if (n === void 0) { n = 0; }
    if (iteratee === void 0) { iteratee = identity_1.default; }
    if (n <= 0 || n === Infinity || n === -Infinity || (0, isNaN_1.default)(n)) {
        return [];
    }
    var iter = iteratee;
    if ((0, isNil_1.default)(iter)) {
        iter = identity_1.default;
    }
    var loopTimes = Math.floor(n);
    var result = [];
    for (var i = 0; i < loopTimes; i++) {
        result.push(iter(i));
    }
    return result;
}
exports.default = times;
