"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findPort = void 0;
const os = require("os");
const node_child_process_1 = require("node:child_process");
function findPort(portNum, maxCount) {
    if (maxCount > 20) {
        return -1;
    }
    if (os.type() == 'Windows_NT') {
        // windows
        const netStat = (0, node_child_process_1.spawnSync)('netstat', ['-ano']);
        if (netStat.stderr.toString().trim()) {
            return -1;
        }
        if (netStat.stdout.toString().indexOf(`:${portNum}`) > -1) {
            maxCount++;
            return findPort(portNum + 1, maxCount);
        }
        else {
            return portNum;
        }
    }
    else if (os.type() == 'Darwin') {
        // mac
        const netStat = (0, node_child_process_1.spawnSync)('lsof', [`-i:${portNum}`]);
        if (netStat.stdout.toString().trim()) {
            maxCount++;
            return findPort(portNum + 1, maxCount);
        }
        else {
            return portNum;
        }
    }
    return portNum;
}
exports.findPort = findPort;
