import { Component } from '@ohos/sdkmanager-common';
/**
 * OneHarmonyOS SDKInfoHandler
 * HarmonyOS发布的SDK与OpenHarmony发布的SDK应该都在实现该接口，原有需要获取HarmonyOS页签下SDK都可以通过该接口获取
 *
 * @since 2023-05-04
 */
export interface UniSdkInfoHandler {
    /**
     * 根据version获取SDK，这个version可以是HarmonyOS Version，可以是API Version，根据实现，其含义会存在区别
     *
     * 注意：由于HarmonyOS Version 3.0.0同时对应api7和api8，参数传入3.0.0时，这里无法返回多个值，因此做特殊处理，只返回api8的SDK，
     * 正常情况下调用者查询api<9的SDK时只会传入OpenHarmony的API Version，所以正常调用是没有问题的
     *
     * @param version apiVersion的字符串形式或者HarmonyOSVersion
     * @return path与Component的键值对
     */
    getLocalSdks(version: string): Map<string, Component>;
    /**
     * 根据version获取SDK，这个version可以是HarmonyOS Version，可以是API Version，根据实现，其含义会存在区别
     * 如果SDK不存在，就去下载
     *
     * @param version version apiVersion的字符串形式或者HarmonyOSVersion
     * @param paths 需要的SDK的paths集合
     * @return path与Component的键值对
     */
    getOrDownload(version: string, paths: string[]): Promise<Map<string, Component>>;
}
