"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArkUIXInstallTask = void 0;
const abstract_install_task_1 = require("../../core/task/abstract-install-task");
const sdk_exception_1 = require("../../core/api/sdk-exception");
const error_tip_1 = require("../../core/api/error-tip");
const path_1 = __importDefault(require("path"));
const arkuix_component_constants_1 = require("../constants/arkuix-component-constants");
const os_1 = __importDefault(require("os"));
class ArkUIXInstallTask extends abstract_install_task_1.AbstractInstallTask {
    constructor(component, sdkSettings, netClient) {
        super(component, sdkSettings, netClient);
    }
    download(progress) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const downloadUrl = (_a = this.component.getArchive()) === null || _a === void 0 ? void 0 : _a.getUrl();
            if (!downloadUrl) {
                throw new sdk_exception_1.SdkException('Could not found download url.', new error_tip_1.ErrorTip('Could not found download url.', 'The network or server is abnormal.', `${os_1.default.EOL}1. Check the network connection and download the file again.\
            ${os_1.default.EOL}2. If the issue persists, choose Help > Show Log in Explorer to obtain logs, \
          and then choose Help > Contact Support for technical assistance.`));
            }
            progress.info(`Downloading ${downloadUrl}...`);
            const downloadLocation = path_1.default.resolve(this.getWorkDir(), this.getFileNameFromUrl(downloadUrl));
            yield this.downloadHelper(downloadUrl, downloadLocation, progress);
            return downloadLocation;
        });
    }
    getUniPackageName() {
        return arkuix_component_constants_1.ARKUIX_UNI_PACKAGE;
    }
}
exports.ArkUIXInstallTask = ArkUIXInstallTask;
