"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaDto = exports.AbstractComponentDto = void 0;
const utils_1 = require("../util/utils");
class AbstractComponentDto {
    constructor() {
        this.apiVersion = 0;
        this.displayName = '';
        this.path = '';
        this.releaseType = '';
        this.version = '';
        this.license = '';
    }
    compareTo(other) {
        const comparePath = this.path.localeCompare(other.getPath());
        if (comparePath !== 0) {
            return comparePath;
        }
        const compareApiVersion = this.apiVersion - other.getApiVersion();
        if (compareApiVersion !== 0) {
            return compareApiVersion;
        }
        return (0, utils_1.compareVersion)(this.version, other.getVersion());
    }
    getApiVersion() {
        return this.apiVersion;
    }
    getDisplayName() {
        return this.displayName;
    }
    getLocation() {
        return this.location;
    }
    getMeta() {
        return this.meta;
    }
    getPath() {
        return this.path;
    }
    getReleaseType() {
        return this.releaseType;
    }
    getVersion() {
        return this.version;
    }
    hasApiVersion() {
        return this.apiVersion > 0;
    }
    getLicense() {
        return this.license;
    }
    getFullName() {
        return `${this.displayName}:${this.version}`;
    }
}
exports.AbstractComponentDto = AbstractComponentDto;
class MetaDto {
    constructor() {
        this.metaVersion = '';
    }
    getMetaVersion() {
        return this.metaVersion;
    }
}
exports.MetaDto = MetaDto;
