"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQueryLicenseUrl = exports.getQueryMetaUrl = void 0;
const url_contants_1 = require("../../core/constants/url-contants");
const utils_1 = require("../../core/util/utils");
const SERVICE_NAME = 'com.huawei.devecostudio.global';
const KEY_SDK = 'ohsdk';
/**
 * 查询SDK元数据的地址
 * @param grsService
 */
function getQueryMetaUrl(grsService) {
    return `${getServerAddress(grsService)}/sdkmanager/v5/ohos/getSdkList`;
}
exports.getQueryMetaUrl = getQueryMetaUrl;
/**
 * 查询license的地址
 * @param grsService
 */
function getQueryLicenseUrl(grsService) {
    return `${getServerAddress(grsService)}/sdkmanager/v4/ohos/licenses`;
}
exports.getQueryLicenseUrl = getQueryLicenseUrl;
function getServerAddress(grsService) {
    const domain = grsService.getUrl(SERVICE_NAME, KEY_SDK);
    if ((0, utils_1.isEmpty)(domain)) {
        return url_contants_1.urls.harmonyOSRepo;
    }
    return domain;
}
