import { Obfuscation } from '@ohos/hvigor-arkts-compose';
import { AotCompileModeEnum } from '../../enum/aot-compile-mode-enum.js';
import { CompileModeEnum } from '../../enum/compile-mode-enum.js';
import { Named, Option, RequiredNamed } from '../options.js';
export interface BuildOptionWithName extends Named, BuildOpt {
    copyFrom?: string;
}
export interface BuildOpt extends ProjectBuildOpt, ModuleBuildOpt {
}
interface ProjectBuildOpt {
    packOptions?: PackOpt;
}
interface ModuleBuildOpt extends HapModuleBuildOpt, HarModuleBuildOpt {
}
interface HarModuleBuildOpt extends CommonModuleBuildOpt {
    artifactType?: string;
}
interface HapModuleBuildOpt extends CommonModuleBuildOpt {
    debuggable?: boolean;
    resOptions?: object;
    sourceOption?: SourceOpt;
    compileMode?: CompileModeEnum;
    aotCompileMode?: AotCompileModeEnum;
    apPath?: string;
}
interface CommonModuleBuildOpt extends Option {
    externalNativeOptions?: ExternalNativeOpt;
    napiLibFilterOption?: NapiLibFilterOpt;
    arkOptions?: ArkOptions;
    nativeLib?: NativeLib;
}
export interface NativeLib extends Option {
    debugSymbol?: DebugSymbol;
    filter?: NapiLibFilterOpt;
    headerPath?: string;
}
export interface DebugSymbol extends Option {
    strip?: boolean;
    exclude?: string[];
}
export interface NapiLibFilterOpt extends Option {
    excludes?: string[];
    pickFirsts?: string[];
    pickLasts?: string[];
    enableOverride?: boolean;
}
export interface ExternalNativeOpt extends Option {
    path?: string;
    arguments?: string;
    abiFilters?: string[];
    cppFlags?: string;
    cFlags?: string;
    targets?: string[];
}
export interface ArkOptions {
    aotCompileMode?: AotCompileModeEnum;
    apPath?: string;
    hostPGO?: boolean;
    types?: string[];
    compilePluginFile?: string;
    obfuscation?: Obfuscation;
    buildProfileFields?: object;
    runtimeOnly?: RuntimeOnlyObj;
}
export interface SourceOpt extends Option {
    workers?: string[];
}
export interface RuntimeOnlyObj extends Option {
    sources?: string[];
    packages?: string[];
}
export interface PackOpt extends RequiredNamed {
    buildAppSkipSignHap?: boolean;
}
export {};
