import { PackageJson } from 'type-fest';
import { Dependency, DependencyEnum, DependencyType } from './dependency-interface.js';
/**
 * module对应的所有的har依赖的包信息类
 *
 * @since 2022/5/7
 */
export declare class DefaultNpmDependency implements Dependency {
    private readonly _dependencyName;
    private readonly _dependencyRootPath;
    private readonly _pkgJsonPath;
    private readonly _pkgJsonName;
    private readonly _mainFilePath;
    private readonly _typesFilePath;
    private readonly _dependencyType;
    private readonly _dependencyEnum;
    constructor(dependencyName: string, dependencyRootPath: string, pkgJsonPath: string, pkgJsonObj: PackageJson, dependencyType: DependencyType, dependencyEnum: DependencyEnum);
    getPackageJsonPath(): string;
    getPackageFilePath(): string;
    getPackageName(): string;
    getDependencyName(): string;
    getDependencyRootPath(): string;
    getDependencyMainFilePath(): string;
    getDependencyTypesFilePath(): string;
    getDependencyType(): DependencyType;
    getDependencyEnum(): DependencyEnum;
    hasNative(): boolean;
}
