import { FileSet } from '@ohos/hvigor';
import { TaskInputValue } from '@ohos/hvigor';
import { ModuleTargetData } from './data/hap-task-target-data.js';
import { TargetTaskService } from './service/target-task-service.js';
import { AbstractMergeProfile } from './abstract-merge-profile.js';
/**
 * 合并app.json和module.json5,合并依赖的har中的module.json5
 *
 * @since 2022/1/10
 */
export declare class MergeProfile extends AbstractMergeProfile {
    private _appRes;
    private _moduleTargetRes;
    private readonly _isHarModule;
    private readonly _multiProjects;
    private _ohLibs;
    private _hspDepsTarget;
    private readonly _mergedModuleJson;
    private readonly asanEnable;
    constructor(taskService: TargetTaskService);
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    initTaskDepends(): void;
    protected initHarModuleDepends(): void;
    protected doTaskAction(): void;
    private computeAppJsonOpt;
    private mergeDslConfig;
    private resolveApi;
    private mergeAllHarModuleOpt;
    protected mergeDependsLibs(jsonType: string): string[];
    private transformJson2Opts;
    private mergeHarRequestPermission;
    private mergeHarMetaData;
    private mergeArrayOptions;
    private checkHarApiStatus;
    private harMinApiVersionToAPi;
    /**
     * 定制处理product中部分字段配置
     * @param mergedModuleOpt
     * @param curProduct
     * @private
     */
    private customizeModuleOpt;
    /**
     * 获取依赖的hsp模块的可用target
     *
     * @param targetService
     */
    static calDepHspTargets(targetService: TargetTaskService): Map<string, ModuleTargetData>;
}
