import { TaskDetails } from '@ohos/hvigor';
import { TargetTaskService } from './service/target-task-service.js';
import { OhosHapTask } from './task/ohos-hap-task.js';
/**
 * syscap相关配置预检查任务
 */
export declare class PreCheckSyscap extends OhosHapTask {
    private _log;
    private readonly syscapJsonPath;
    private readonly sourceRoot;
    private readonly jsonFilePath;
    constructor(targetTaskService: TargetTaskService, taskDetails: TaskDetails);
    protected doTaskAction(): void;
    initTaskDepends(): void;
    /**
     * syscap.json中production配置正则校验
     *
     * @param sysCapJson syscap.json
     * @param regExp syscap regExp
     * @param field production配置(addedSysCaps/removedSysCaps)
     * @protected
     */
    protected productionRegexpCheck(sysCapJson: any, regExp: RegExp, field: string): void;
}
