import type { InitialOptionsTsJest as Config } from 'ts-jest';

const config: Config = {
  preset: 'ts-jest',
  testEnvironment: 'node',
  maxConcurrency: 4,
  maxWorkers: 4,
  testPathIgnorePatterns: [
    '/node_modules/',
    '/test/resources/',
    '/test/temp/'
  ],
  testTimeout: 300000,
  testMatch: [
    '**/jest-test/**/*.ts?(x)',
    '**/__tests__/**/*.ts?(x)',
    '**/?(*.)?(long|unit)+(spec|test).ts?(x)'
  ],
  collectCoverageFrom: [
    '**/src/**/*.js'
  ],
  coverageReporters: ['json', 'lcov', 'text', 'clover']
};

export default config;
