"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var baseFindIndex_1 = require("./baseFindIndex");
var ListCache = /** @class */ (function () {
    function ListCache(entries) {
        this.wdkData = [];
        this.size = 0;
        var index = -1;
        var length = entries == null ? 0 : entries.length;
        while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    ListCache.prototype.clear = function () {
        this.wdkData = [];
        this.size = 0;
    };
    ListCache.prototype.delete = function (key) {
        var data = this.wdkData;
        var index = (0, baseFindIndex_1.assocIndexOf)(data, key);
        if (index < 0) {
            return false;
        }
        var lastIndex = data.length - 1;
        if (index === lastIndex) {
            data.pop();
        }
        else {
            data.splice(index, 1);
        }
        --this.size;
        return true;
    };
    ListCache.prototype.get = function (key) {
        var data = this.wdkData;
        var index = (0, baseFindIndex_1.assocIndexOf)(data, key);
        return index < 0 ? undefined : data[index][1];
    };
    ListCache.prototype.has = function (key) {
        return (0, baseFindIndex_1.assocIndexOf)(this.wdkData, key) > -1;
    };
    /**
     * Sets the list cache `key` to `value`.
     *
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */
    ListCache.prototype.set = function (key, value) {
        var data = this.wdkData;
        var index = (0, baseFindIndex_1.assocIndexOf)(data, key);
        if (index < 0) {
            ++this.size;
            data.push([key, value]);
        }
        else {
            data[index][1] = value;
        }
        return this;
    };
    return ListCache;
}());
exports.default = ListCache;
