"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isKey = void 0;
var isArray_1 = __importDefault(require("../isArray"));
var isSymbol_1 = __importDefault(require("../isSymbol"));
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/;
var reIsPlainProp = /^\w*$/;
// 判断key值为字符串还是key路径
function isKey(value, object) {
    if ((0, isArray_1.default)(value)) {
        return false;
    }
    var type = typeof value;
    if (type === 'number' || type === 'symbol' || type === 'boolean'
        || value == null || (0, isSymbol_1.default)(value)) {
        return true;
    }
    return reIsPlainProp.test(value) || !reIsDeepProp.test(value)
        || (object != null && value in Object(object));
}
exports.isKey = isKey;
