"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var hasPath_1 = __importDefault(require("./hasPath"));
/**
 * 判断一个key是否为对象的直接属性
 *
 * @param {Object} object 要查询的对象
 * @param {string | string[]} path 要判断的key
 * @returns {boolean} 如果该key为该对象的直接属性，返回true，否则false
 */
function hasFunc(object, path) {
    if (!(object instanceof Object)) {
        return false;
    }
    return Object.prototype.hasOwnProperty.call(object, path);
}
/**
 * 判断一个key是否为对象的直接属性
 *
 * @param {Object} object 要查询的对象
 * @param {string | Array} path 要判断的key
 * @returns {boolean} 如果该key为该对象的直接属性，返回true，否则false
 */
function has(object, path) {
    if (!(object instanceof Object)) {
        return false;
    }
    return (0, hasPath_1.default)(object, path, hasFunc);
}
exports.default = has;
