"use strict";
/**
 * Creates a slice of `array` with `n` elements taken from the end.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Array
 * @param {Array} array The array to query.
 * @param {number} [nums=1] The number of elements to take.
 * @param guard [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {Array} Returns the slice of `array`.
 * @example
 *
 * _.takeRight([1, 2, 3]);
 * // => [3]
 *
 * _.takeRight([1, 2, 3], 2);
 * // => [2, 3]
 *
 * _.takeRight([1, 2, 3], 5);
 * // => [1, 2, 3]
 *
 * _.takeRight([1, 2, 3], 0);
 * // => []
 */
Object.defineProperty(exports, "__esModule", { value: true });
function takeRight(array, nums, guard) {
    if (nums === void 0) { nums = 1; }
    var length = array == null ? 0 : array.length;
    if (!length) {
        return [];
    }
    var num = nums;
    if (guard || num === undefined) {
        num = 1;
    }
    else if (!num) {
        num = 0;
    }
    if (num === 0) {
        return [];
    }
    var start = length - num >= 0 ? length - num : 0;
    return array.slice(start);
}
exports.default = takeRight;
